/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.living.DraugrEntity;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class SarcophagusBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public ArcRandom arcRandom = Tmp.rnd;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    private static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    private static final BooleanProperty LOOTED = BooleanProperty.m_61465_((String)"looted");
    public static List<Item> spawnableWith = new ArrayList<Item>();
    public static List<Item> halloweenSpawnableWith = new ArrayList<Item>();
    private static final VoxelShape shape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    ItemStack[] armor_head = new ItemStack[]{new ItemStack((ItemLike)Items.f_42407_), new ItemStack((ItemLike)Items.f_42464_), new ItemStack((ItemLike)Items.f_42476_), new ItemStack((ItemLike)Items.f_41852_)};
    ItemStack[] armor_chest = new ItemStack[]{new ItemStack((ItemLike)Items.f_42408_), new ItemStack((ItemLike)Items.f_42465_), new ItemStack((ItemLike)Items.f_42477_), new ItemStack((ItemLike)Items.f_41852_)};
    ItemStack[] armor_legs = new ItemStack[]{new ItemStack((ItemLike)Items.f_42462_), new ItemStack((ItemLike)Items.f_42466_), new ItemStack((ItemLike)Items.f_42478_), new ItemStack((ItemLike)Items.f_41852_)};
    ItemStack[] armor_boots = new ItemStack[]{new ItemStack((ItemLike)Items.f_42463_), new ItemStack((ItemLike)Items.f_42467_), new ItemStack((ItemLike)Items.f_42479_), new ItemStack((ItemLike)Items.f_41852_)};

    public SarcophagusBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOOTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean isHalloween() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.getDayOfMonth();
        int j = localdate.getMonth().getValue();
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }

    private static Direction getNeighbourDirection(BedPart pPart, Direction pDirection) {
        return pPart == BedPart.FOOT ? pDirection : pDirection.m_122424_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    private void spawnSkeletons(Level pLevel, BlockPos pPos, InteractionHand hand) {
        RandomSource rand = pLevel.m_213780_();
        Skeleton entity = (Skeleton)EntityType.f_20524_.m_20615_(pLevel);
        for (int tries = 0; tries < 10; ++tries) {
            double x = (double)pPos.m_123341_() + (rand.m_188500_() - rand.m_188500_()) * 6.0;
            double y = pPos.m_123342_() + rand.m_216339_(1, 2);
            double z = (double)pPos.m_123343_() + (rand.m_188500_() - rand.m_188500_()) * 6.0;
            if (entity == null || !pLevel.m_45756_((Entity)entity, new AABB(x, y, z, x, y, z).m_82400_(1.0))) continue;
            entity.m_7678_(x, y, z, 0.0f, 0.0f);
            entity.m_21008_(hand, spawnableWith.get(rand.m_188503_(spawnableWith.size())).m_7968_());
            if (SarcophagusBlock.isHalloween()) {
                entity.m_8061_(EquipmentSlot.HEAD, halloweenSpawnableWith.get(rand.m_188503_(halloweenSpawnableWith.size())).m_7968_());
            } else if ((double)rand.m_188501_() <= 0.4) {
                entity.m_8061_(EquipmentSlot.HEAD, this.armor_head[rand.m_188503_(this.armor_head.length)]);
            }
            if ((double)rand.m_188501_() <= 0.4) {
                entity.m_8061_(EquipmentSlot.CHEST, this.armor_chest[rand.m_188503_(this.armor_chest.length)]);
                entity.m_8061_(EquipmentSlot.LEGS, this.armor_legs[rand.m_188503_(this.armor_legs.length)]);
                entity.m_8061_(EquipmentSlot.FEET, this.armor_boots[rand.m_188503_(this.armor_boots.length)]);
            }
            pLevel.m_7967_((Entity)entity);
        }
    }

    private void spawnDraugr(Level pLevel, BlockPos pPos, InteractionHand hand) {
        RandomSource rand = pLevel.m_213780_();
        DraugrEntity entity = (DraugrEntity)((EntityType)EntityTypeRegistry.DRAUGR.get()).m_20615_(pLevel);
        for (int tries = 0; tries < 10; ++tries) {
            double x = (double)pPos.m_123341_() + (rand.m_188500_() - rand.m_188500_()) * 6.0;
            double y = pPos.m_123342_() + rand.m_216339_(1, 2);
            double z = (double)pPos.m_123343_() + (rand.m_188500_() - rand.m_188500_()) * 6.0;
            if (entity == null || !pLevel.m_45756_((Entity)entity, new AABB(x, y, z, x, y, z).m_82400_(1.0))) continue;
            entity.m_7678_(x, y, z, 0.0f, 0.0f);
            entity.m_21008_(hand, spawnableWith.get(rand.m_188503_(spawnableWith.size())).m_7968_());
            if (SarcophagusBlock.isHalloween()) {
                entity.m_8061_(EquipmentSlot.HEAD, halloweenSpawnableWith.get(rand.m_188503_(halloweenSpawnableWith.size())).m_7968_());
            }
            pLevel.m_7967_((Entity)entity);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        RandomSource rand = pLevel.m_213780_();
        BlockPos oppositePos = pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_));
        if (pState.m_61143_(PART) == BedPart.HEAD) {
            oppositePos = pPos.m_121945_(((Direction)pState.m_61143_((Property)f_54117_)).m_122424_());
        }
        if (!((Boolean)pState.m_61143_((Property)OPEN)).booleanValue()) {
            int i;
            pLevel.m_46597_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LOOTED, (Comparable)Boolean.valueOf(false)));
            BlockState oppositeState = pLevel.m_8055_(oppositePos);
            if (oppositeState.m_60734_() == this) {
                pLevel.m_46597_(oppositePos, (BlockState)((BlockState)oppositeState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LOOTED, (Comparable)Boolean.valueOf(false)));
            }
            if (!pLevel.f_46443_ && pLevel instanceof ServerLevel) {
                ServerLevel serv = (ServerLevel)pLevel;
                double posX = (pPos.m_252807_().f_82479_ + oppositePos.m_252807_().f_82479_) / 2.0;
                double posY = (pPos.m_7494_().m_252807_().f_82480_ + oppositePos.m_7494_().m_252807_().f_82480_) / 2.0;
                double posZ = (pPos.m_252807_().f_82481_ + oppositePos.m_252807_().f_82481_) / 2.0;
                PacketHandler.sendToTracking((Level)serv, pPos, new SmokeParticlePacket(120, posX, posY - (double)0.135f, posZ, 0.125f, 0.0f, 0.125f, 255, 255, 255));
            }
            for (i = 0; i < 10; ++i) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pPos.m_123341_() + rand.m_188500_(), (double)((float)pPos.m_123342_() + 1.0f), (double)pPos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)oppositePos.m_123341_() + rand.m_188500_(), (double)((float)oppositePos.m_123342_() + 1.0f), (double)oppositePos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
            }
            pPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.valoria.sarcophagus").m_130940_(ChatFormatting.GRAY), true);
            i = 0;
            while ((float)i < Mth.m_216267_((RandomSource)RandomSource.m_216327_(), (float)1.0f, (float)4.0f)) {
                InteractionHand hand;
                boolean randomHand = (double)Mth.m_216267_((RandomSource)RandomSource.m_216327_(), (float)0.0f, (float)1.0f) < 0.5;
                InteractionHand interactionHand = hand = randomHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                if (this.arcRandom.fiftyFifty()) {
                    this.spawnSkeletons(pLevel, pPos, hand);
                } else {
                    this.spawnDraugr(pLevel, pPos, hand);
                }
                pLevel.m_5594_(null, pPos, (SoundEvent)SoundsRegistry.SARCOPHAGUS_OPEN.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
                ++i;
            }
        }
        if (((Boolean)pState.m_61143_((Property)OPEN)).booleanValue() && !((Boolean)pState.m_61143_((Property)LOOTED)).booleanValue()) {
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                Vec3 block = new Vec3((double)((float)pPos.m_123341_() - 0.5f), (double)pPos.m_123342_(), (double)((float)pPos.m_123343_() - 0.5f));
                Utils.Items.spawnLoot((Level)pLevel, (BlockPos)pPos.m_7494_(), (Collection)Utils.Items.createLoot((ResourceLocation)new ResourceLocation("valoria", "items/sarcophagus"), (LootParams)Utils.Items.getGiftParameters((ServerLevel)((ServerLevel)pLevel), (Vec3)block, (Entity)serverPlayer)));
                pLevel.m_46597_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LOOTED, (Comparable)Boolean.valueOf(true)));
                BlockState oppositeState = pLevel.m_8055_(oppositePos);
                if (oppositeState.m_60734_() == this) {
                    pLevel.m_46597_(oppositePos, (BlockState)((BlockState)oppositeState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LOOTED, (Comparable)Boolean.valueOf(true)));
                }
            }
            for (int i = 0; i < 3; ++i) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)pPos.m_123341_() + rand.m_188500_(), (double)((float)pPos.m_123342_() + 1.0f), (double)pPos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)oppositePos.m_123341_() + rand.m_188500_(), (double)((float)oppositePos.m_123342_() + 1.0f), (double)oppositePos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            BlockState blockstate = (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            pLevel.m_7731_(pPos, blockstate, 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == SarcophagusBlock.getNeighbourDirection((BedPart)pState.m_61143_(PART), (Direction)pState.m_61143_((Property)f_54117_))) {
            return pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(PART) != pState.m_61143_(PART) ? pState : Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            BedPart part = (BedPart)pState.m_61143_(PART);
            BlockPos pNeighborPos = pPos.m_121945_(SarcophagusBlock.getNeighbourDirection(part, (Direction)pState.m_61143_((Property)f_54117_)));
            BlockState pNeighborState = pLevel.m_8055_(pNeighborPos);
            if (!(part != BedPart.FOOT || pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(PART) == pState.m_61143_(PART))) {
                pLevel.m_5898_(null, 2001, pNeighborPos, Block.m_49956_((BlockState)pNeighborState));
                pLevel.m_7731_(pNeighborPos, Blocks.f_50016_.m_49966_(), 35);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction $$1 = pContext.m_8125_();
        BlockPos $$2 = pContext.m_8083_();
        BlockPos $$3 = $$2.m_121945_($$1);
        Level $$4 = pContext.m_43725_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return $$4.m_8055_($$3).m_60629_(pContext) && $$4.m_6857_().m_61937_($$3) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)$$1)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag)) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.f_46443_) {
            BlockPos $$5 = pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_));
            pLevel.m_7731_($$5, (BlockState)pState.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            pLevel.m_6289_(pPos, Blocks.f_50016_);
            pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
        builder.m_61104_(new Property[]{PART});
        builder.m_61104_(new Property[]{OPEN});
        builder.m_61104_(new Property[]{LOOTED});
        builder.m_61104_(new Property[]{WATERLOGGED});
        super.m_7926_(builder);
    }

    public long m_7799_(BlockState pState, BlockPos pPos) {
        BlockPos $$2 = pPos.m_5484_((Direction)pState.m_61143_((Property)f_54117_), pState.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)$$2.m_123341_(), (int)pPos.m_123342_(), (int)$$2.m_123343_());
    }
}

