/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.client.ui.menus.KegMenu;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.block.entity.BlockSimpleInventory;
import com.idark.valoria.registries.block.entity.KegBlockEntity;
import com.idark.valoria.util.ValoriaUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;

public class KegBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty BREWING = BooleanProperty.m_61465_((String)"brewing");
    private static final VoxelShape shape_west_east = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape shape_north_south = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);

    public KegBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BREWING, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isBrewing(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BREWING);
    }

    public static void setBrewing(Level level, BlockPos pos, BlockState state, boolean pBrew) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)BREWING, (Comparable)Boolean.valueOf(pBrew)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return TickableBlockEntity.getTickerHelper();
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BlockSimpleInventory && !((BlockSimpleInventory)tile).getItemHandler().m_8020_(0).m_204117_(TagsRegistry.CUP_DRINKS) && !((BlockSimpleInventory)tile).getItemHandler().m_8020_(0).m_204117_(TagsRegistry.BOTTLE_DRINKS)) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((BlockSimpleInventory)tile).getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public MenuProvider getMenuProvider(Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((p_57074_, p_57075_, p_57076_) -> new KegMenu(p_57074_, pLevel, pPos, p_57076_, p_57075_), (Component)Component.m_237115_((String)"menu.valoria.keg"));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isHoldingBottle;
        KegBlockEntity tile = (KegBlockEntity)world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand).m_41777_();
        boolean isHoldingCup = stack.m_41720_() == ItemsRegistry.woodenCup.get();
        boolean bl = isHoldingBottle = stack.m_41720_() == ItemsRegistry.bottle.get();
        if (isHoldingCup || isHoldingBottle) {
            if (!tile.itemOutputHandler.getStackInSlot(0).m_41619_() && this.isCupOrBottle(tile, player, hand)) {
                BlockSimpleInventory.addHandPlayerItem(world, player, hand, stack, tile.itemOutputHandler.getStackInSlot(0).m_41720_().m_7968_());
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                tile.itemOutputHandler.extractItem(0, 1, false);
                ValoriaUtils.SUpdateTileEntityPacket(tile);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serv = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serv, (MenuProvider)this.getMenuProvider(world, pos), buf -> buf.m_130064_(pos));
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isCupOrBottle(KegBlockEntity tile, Player player, InteractionHand hand) {
        ItemStack itemStack = tile.itemOutputHandler.getStackInSlot(0);
        ItemStack playerHeldItem = player.m_21120_(hand).m_41777_();
        boolean isHoldingCup = playerHeldItem.m_41720_() == ItemsRegistry.woodenCup.get();
        boolean isHoldingBottle = playerHeldItem.m_41720_() == ItemsRegistry.bottle.get();
        return isHoldingCup && itemStack.m_204117_(TagsRegistry.CUP_DRINKS) || isHoldingBottle && itemStack.m_204117_(TagsRegistry.BOTTLE_DRINKS);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(id, param);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        switch (direction) {
            case SOUTH: 
            case NORTH: {
                return shape_north_south;
            }
            case WEST: 
            case EAST: {
                return shape_west_east;
            }
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{BREWING});
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nonnull
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new KegBlockEntity(pPos, pState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)BREWING, (Comparable)Boolean.valueOf(false));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }
}

