/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.client.ui.menus.HeavyWorkbenchMenu;
import com.idark.valoria.registries.block.types.WorkbenchPart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HeavyWorkbenchBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<WorkbenchPart> PART = EnumProperty.m_61587_((String)"part", WorkbenchPart.class);
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"menu.valoria.heavy_workbench");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public HeavyWorkbenchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)WorkbenchPart.BOTTOM_LEFT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED, PART, f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        Direction direction = pContext.m_8125_().m_122424_();
        BlockPos pos = pContext.m_8083_();
        WorldBorder border = pContext.m_43725_().m_6857_();
        BlockPos pos1 = pos.m_121945_(direction.m_122428_());
        BlockPos pos2 = pos.m_7494_();
        BlockPos pos3 = pos.m_7494_().m_121945_(direction.m_122428_());
        if (pContext.m_43725_().m_8055_(pos1).m_60629_(pContext) && pContext.m_43725_().m_8055_(pos2).m_60629_(pContext) && pContext.m_43725_().m_8055_(pos3).m_60629_(pContext) && border.m_61937_(pos) && border.m_61937_(pos1) && border.m_61937_(pos2) && border.m_61937_(pos3)) {
            boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_(PART, (Comparable)((Object)WorkbenchPart.BOTTOM_RIGHT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        WorkbenchPart part = (WorkbenchPart)((Object)pState.m_61143_(PART));
        BlockPos mainPos = pPos;
        switch (part) {
            case TOP_RIGHT: {
                mainPos = pPos.m_7495_();
                break;
            }
            case BOTTOM_LEFT: {
                mainPos = pPos.m_121945_(facing.m_122427_());
                break;
            }
            case TOP_LEFT: {
                mainPos = pPos.m_121945_(facing.m_122427_()).m_7495_();
                break;
            }
        }
        BlockState mainState = pLevel.m_8055_(mainPos);
        if (!(mainState.m_60734_() instanceof HeavyWorkbenchBlock)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            BlockState blockstate = (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            pLevel.m_7731_(pPos, blockstate, 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public final VoxelShape makeShape(BlockState state) {
        if (state.m_61143_(PART) == WorkbenchPart.BOTTOM_LEFT || state.m_61143_(PART) == WorkbenchPart.BOTTOM_RIGHT) {
            return Shapes.m_83144_();
        }
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        VoxelShape originalShape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.6875, (double)1.0, (double)0.875, (double)1.0);
        return switch (facing) {
            case Direction.EAST -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.3125, (double)0.875, (double)1.0);
            case Direction.SOUTH -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)0.3125);
            case Direction.WEST -> Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0);
            default -> originalShape;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.makeShape(state);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        pPlayer.m_5893_(pState.m_60750_(pLevel, pPos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState pState, Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((p_57074_, p_57075_, p_57076_) -> new HeavyWorkbenchMenu(p_57074_, p_57075_, ContainerLevelAccess.m_39289_((Level)pLevel, (BlockPos)pPos)), CONTAINER_TITLE);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_) {
            WorkbenchPart part = (WorkbenchPart)((Object)pState.m_61143_(PART));
            Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
            BlockPos mainPos = pPos;
            switch (part) {
                case TOP_RIGHT: {
                    mainPos = pPos.m_7495_();
                    break;
                }
                case BOTTOM_LEFT: {
                    mainPos = pPos.m_121945_(facing.m_122427_());
                    break;
                }
                case TOP_LEFT: {
                    mainPos = pPos.m_121945_(facing.m_122427_()).m_7495_();
                    break;
                }
            }
            BlockState mainState = pLevel.m_8055_(mainPos);
            BlockState leftState = pLevel.m_8055_(mainPos.m_121945_(facing.m_122428_()));
            BlockState topState = pLevel.m_8055_(mainPos.m_7494_());
            BlockState topLeftState = pLevel.m_8055_(mainPos.m_121945_(facing.m_122428_()).m_7494_());
            if (mainState.m_60734_() instanceof HeavyWorkbenchBlock && mainPos != pPos) {
                pLevel.m_46961_(mainPos, !pPlayer.m_7500_());
            }
            if (leftState.m_60734_() instanceof HeavyWorkbenchBlock && mainPos.m_121945_(facing.m_122428_()) != pPos) {
                pLevel.m_46961_(mainPos.m_121945_(facing.m_122428_()), !pPlayer.m_7500_());
            }
            if (topState.m_60734_() instanceof HeavyWorkbenchBlock && mainPos.m_7494_() != pPos) {
                pLevel.m_46961_(mainPos.m_7494_(), !pPlayer.m_7500_());
            }
            if (topLeftState.m_60734_() instanceof HeavyWorkbenchBlock && mainPos.m_121945_(facing.m_122428_()).m_7494_() != pPos) {
                pLevel.m_46961_(mainPos.m_121945_(facing.m_122428_()).m_7494_(), !pPlayer.m_7500_());
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.f_46443_) {
            Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
            BlockPos bottom_left_pos = pPos.m_121945_(direction.m_122428_());
            BlockPos top_right_pos = pPos.m_7494_();
            BlockPos top_left_pos = pPos.m_121945_(direction.m_122428_()).m_7494_();
            pLevel.m_7731_(bottom_left_pos, (BlockState)((BlockState)pState.m_61124_(PART, (Comparable)((Object)WorkbenchPart.BOTTOM_LEFT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(bottom_left_pos).m_76152_() == Fluids.f_76193_)), 3);
            pLevel.m_7731_(top_right_pos, (BlockState)((BlockState)pState.m_61124_(PART, (Comparable)((Object)WorkbenchPart.TOP_RIGHT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(top_right_pos).m_76152_() == Fluids.f_76193_)), 3);
            pLevel.m_7731_(top_left_pos, (BlockState)((BlockState)pState.m_61124_(PART, (Comparable)((Object)WorkbenchPart.TOP_LEFT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(top_left_pos).m_76152_() == Fluids.f_76193_)), 3);
        }
    }

    public long m_7799_(BlockState pState, BlockPos pPos) {
        return (long)((WorkbenchPart)((Object)pState.m_61143_(PART))).ordinal() + (long)pPos.m_123341_() + (long)pPos.m_123342_() + (long)pPos.m_123343_();
    }
}

