/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.core.interfaces.FleshSpreaderBehaviour;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.block.types.FleshSpreader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import pro.komaru.tridot.util.Tmp;

public class FleshBlock
extends Block
implements FleshSpreaderBehaviour {
    public FleshBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public int attemptUseCharge(FleshSpreader.ChargeCursor pCursor, LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom, FleshSpreader pSpreader, boolean pShouldConvertBlocks) {
        int i = pCursor.getCharge();
        if (i != 0 && pRandom.m_188503_(pSpreader.chargeDecayRate()) == 0) {
            BlockPos blockpos = pCursor.getPos();
            boolean flag = blockpos.m_123314_((Vec3i)pPos, (double)pSpreader.noGrowthRadius());
            if (!flag && FleshBlock.canPlaceGrowth(pLevel, blockpos)) {
                int j = pSpreader.growthSpawnCost();
                if (pRandom.m_188503_(j) < i) {
                    BlockPos blockpos1 = blockpos.m_7494_();
                    BlockState blockstate = this.getRandomGrowthState(pLevel, blockpos1, pRandom);
                    pLevel.m_7731_(blockpos1, blockstate, 3);
                    pLevel.m_5594_(null, blockpos, blockstate.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, i - j);
            }
            return pRandom.m_188503_(pSpreader.additionalDecayRate()) != 0 ? i : i - (flag ? 1 : FleshBlock.getDecayPenalty(pSpreader, blockpos, pPos, i));
        }
        return i;
    }

    private static int getDecayPenalty(FleshSpreader pSpreader, BlockPos pCursorPos, BlockPos pRootPos, int pCharge) {
        int i = pSpreader.noGrowthRadius();
        float f = Mth.m_14207_((float)((float)Math.sqrt(pCursorPos.m_123331_((Vec3i)pRootPos)) - (float)i));
        int j = Mth.m_144944_((int)(24 - i));
        float f1 = Math.min(1.0f, f / (float)j);
        return Math.max(1, (int)((float)pCharge * f1 * 0.5f));
    }

    private BlockState getRandomGrowthState(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockState blockstate = Tmp.rnd.chance(25) ? ((Block)BlockRegistry.fleshCyst.get()).m_49966_() : ((Block)BlockRegistry.bloodVein.get()).m_49966_();
        return blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && !pLevel.m_6425_(pPos).m_76178_() ? (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE) : blockstate;
    }

    private static boolean canPlaceGrowth(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49990_) && blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            int i = 0;
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-4, 0, -4), (BlockPos)pPos.m_7918_(4, 2, 4))) {
                BlockState blockstate1 = pLevel.m_8055_(blockpos);
                if (!blockstate.m_60713_((Block)BlockRegistry.fleshCyst.get()) || !blockstate1.m_60713_((Block)BlockRegistry.bloodVein.get())) {
                    ++i;
                }
                if (i <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canChangeBlockStateOnSpread() {
        return false;
    }
}

