/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.block.entity.AbstractAltarBlockEntity;
import com.idark.valoria.registries.entity.living.boss.WickedCrystal;
import com.idark.valoria.util.Pal;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;

public class WickedAltarBlockEntity
extends AbstractAltarBlockEntity {
    public WickedAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.WICKED_ALTAR.get(), pos, state);
    }

    @Override
    public void summonParticles(int tick) {
        double angle = ((double)tick + (double)this.progress * Math.PI) * 0.925;
        double y = angle * 0.01025;
        for (int a = 0; a < 3; ++a) {
            double radius = 0.5 * (1.0 - (double)this.progress / (double)this.progressMax) * (1.0 - (double)a * 2.5);
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            ParticleBuilder.create((RegistryObject)TridotParticles.SMOKE).setColorData(ColorParticleData.create((Col)Pal.softMagenta, (Col)Col.magenta).build()).setTransparencyData(GenericParticleData.create((float)0.425f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)((float)a * 0.125f), (float)0.1f, (float)0.0f).build()).setLifetime(35).spawn(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f) + x, (double)this.f_58858_.m_123342_() + (1.0 - (double)a / 1.25) + y, (double)((float)this.f_58858_.m_123343_() + 0.5f) + z);
        }
        ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.softMagenta, (Col)Col.magenta).build()).setTransparencyData(GenericParticleData.create((float)0.125f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.125f, (float)0.1f, (float)0.0f).build()).setLifetime(60).spawn(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 1.5f) + y, (double)((float)this.f_58858_.m_123343_() + 0.5f));
    }

    @Override
    public SoundEvent getSummonSound() {
        return (SoundEvent)SoundsRegistry.WICKED_CRYSTAL_SUMMON.get();
    }

    public WickedCrystal getBoss(Level level) {
        return new WickedCrystal((EntityType<? extends PathfinderMob>)((EntityType)EntityTypeRegistry.WICKED_CRYSTAL.get()), level);
    }

    @Override
    public void summonBoss(Level level) {
        WickedCrystal boss = this.getBoss(level);
        boss.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (float)this.f_58858_.m_123342_() + 2.75f, (double)this.f_58858_.m_123343_() + 0.5, 0.0f, 0.0f);
        level.m_7967_((Entity)boss);
        boss.m_21373_();
    }
}

