/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.client.ui.menus.SoulInfuserMenu;
import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.item.ISoulItem;
import com.idark.valoria.registries.item.recipe.SoulInfuserRecipe;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.ValoriaUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import pro.komaru.tridot.util.Col;

public class SoulInfuserBlockEntity
extends BlockEntity
implements MenuProvider,
TickableBlockEntity {
    public final ItemStackHandler itemHandler = this.createHandler(2);
    public final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    public final ItemStackHandler itemOutputHandler = this.createHandler(1);
    public final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> this.itemOutputHandler);
    public int progress = 0;
    public int progressMax = 0;
    public boolean startCraft = false;

    public SoulInfuserBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public SoulInfuserBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesRegistry.SOUL_INFUSER_BLOCK_ENTITY.get(), pos, state);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                SoulInfuserBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                CombinedInvWrapper item = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.itemOutputHandler});
                return LazyOptional.of(() -> item).cast();
            }
            if (side == Direction.DOWN) {
                return this.outputHandler.cast();
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        Optional<SoulInfuserRecipe> recipeOpt = this.getCurrentRecipe();
        if (recipeOpt.isEmpty()) {
            this.resetProgress();
            return;
        }
        SoulInfuserRecipe recipe = recipeOpt.get();
        if (this.canCraft(recipe)) {
            if (this.f_58857_.f_46443_) {
                double targetX = 0.5;
                double targetY = 1.75;
                double targetZ = 0.5;
                double angle = ((double)ClientTick.partialTicks + (double)this.progress * Math.PI) * 0.4925;
                double y = angle * 0.00125;
                for (int a = 0; a < 3; ++a) {
                    double radius = 1.0 * (1.0 - (double)this.progress / (double)this.progressMax) * (1.0 - (double)a * 2.5);
                    double x = Math.cos(angle) * radius;
                    double z = Math.sin(angle) * radius;
                    double dx = targetX - x;
                    double dy = targetY - y;
                    double dz = targetZ - z;
                    double speed = 0.05;
                    double motionX = dx * speed;
                    double motionY = dy * speed;
                    double motionZ = dz * speed;
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.crystalBlue, (Col)Pal.softBlue).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.21f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)((float)a * 0.125f), (float)0.1f, (float)0.0f).build()).setLifetime(25).setVelocity(motionX, motionY, motionZ)).spawn(this.f_58857_, (double)this.f_58858_.m_123341_() + targetX + x, (double)this.f_58858_.m_123342_() + y, (double)this.f_58858_.m_123343_() + targetZ + z);
                }
                ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.crystalBlue, (Col)Pal.softBlue).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.15f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)1.0f, (float)0.1f, (float)0.0f).build()).setLifetime(10).spawn(this.f_58857_, (double)this.f_58858_.m_123341_() + targetX, (double)this.f_58858_.m_123342_() + targetY, (double)this.f_58858_.m_123343_() + targetZ);
            }
            ItemStack input = this.itemHandler.getStackInSlot(0);
            ItemStack soulCollector = this.itemHandler.getStackInSlot(1);
            if (this.getSouls(soulCollector) >= recipe.getSouls(input) && this.getSouls(input) < this.getMaxSouls(input)) {
                this.increaseCraftingProgress();
                this.setMaxProgress();
                this.m_6596_();
                if (this.hasProgressFinished()) {
                    this.craftItem(recipe);
                    this.resetProgress();
                }
            }
        } else {
            this.resetProgress();
        }
    }

    private boolean canCraft(SoulInfuserRecipe recipe) {
        ItemStack recipeOutput = recipe.m_8043_(this.f_58857_.m_9598_());
        ItemStack outputSlot = this.itemOutputHandler.getStackInSlot(0);
        if (outputSlot.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)outputSlot, (ItemStack)recipeOutput)) {
            return false;
        }
        if (!ItemStack.m_150942_((ItemStack)outputSlot, (ItemStack)recipeOutput)) {
            return false;
        }
        return outputSlot.m_41613_() + recipeOutput.m_41613_() <= outputSlot.m_41741_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound() {
    }

    public Optional<SoulInfuserRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)SoulInfuserRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private void craftItem(SoulInfuserRecipe recipe) {
        if (this.f_58857_.m_5776_()) {
            for (int i = 0; i < 8; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.55, (double)this.f_58858_.m_123343_() + 0.5, (Math.random() - 0.5) * 0.1, Math.random() * 0.1, (Math.random() - 0.5) * 0.1);
            }
        }
        ItemStack infusableItem = this.itemHandler.getStackInSlot(0);
        ItemStack soulCollector = this.itemHandler.getStackInSlot(1);
        int soulsToConsume = recipe.getSouls(infusableItem);
        this.consumeSouls(soulCollector, soulsToConsume);
        soulCollector.m_220157_(1, this.f_58857_.f_46441_, null);
        if (soulCollector.m_41773_() >= soulCollector.m_41776_()) {
            this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            this.itemHandler.setStackInSlot(1, soulCollector);
        }
        ItemStack recipeResult = recipe.assemble((IItemHandler)this.itemHandler, this.f_58857_.m_9598_());
        ItemStack outputSlot = this.itemOutputHandler.getStackInSlot(0);
        if (outputSlot.m_41619_()) {
            this.itemOutputHandler.setStackInSlot(0, recipeResult);
        } else {
            outputSlot.m_41769_(recipeResult.m_41613_());
        }
        if (this.getSouls(soulCollector) == 0) {
            this.itemHandler.setStackInSlot(1, ((Item)ItemsRegistry.soulCollectorEmpty.get()).m_7968_());
            this.itemHandler.getStackInSlot(1).m_41721_(soulCollector.m_41773_());
        }
        this.itemHandler.extractItem(0, 1, false);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.progressMax;
    }

    private void increaseCraftingProgress() {
        this.startCraft = true;
        Optional<SoulInfuserRecipe> recipe = this.getCurrentRecipe();
        if (this.progress < recipe.get().getTime()) {
            ++this.progress;
        }
    }

    private void setMaxProgress() {
        Optional<SoulInfuserRecipe> recipe = this.getCurrentRecipe();
        if (this.progressMax <= 0) {
            this.progressMax = recipe.map(SoulInfuserRecipe::getTime).orElse(200);
        }
    }

    private void resetProgress() {
        if (this.progress != 0 || this.startCraft) {
            this.progress = 0;
            this.progressMax = 0;
            this.startCraft = false;
            this.m_6596_();
        }
    }

    public int getMaxSouls(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ISoulItem) {
            ISoulItem soulItem = (ISoulItem)item;
            return soulItem.getMaxSouls();
        }
        return 0;
    }

    public int getSouls(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ISoulItem) {
            ISoulItem soulItem = (ISoulItem)item;
            return soulItem.getCurrentSouls(stack);
        }
        return 0;
    }

    public void setSouls(ItemStack stack, int souls) {
        Item item = stack.m_41720_();
        if (item instanceof ISoulItem) {
            ISoulItem soulItem = (ISoulItem)item;
            soulItem.setSouls(souls, stack);
        }
    }

    public void consumeSouls(ItemStack stack, int souls) {
        Item item = stack.m_41720_();
        if (item instanceof ISoulItem) {
            ISoulItem soulItem = (ISoulItem)item;
            soulItem.consumeSouls(souls, stack);
        }
    }

    public void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128365_("output", (Tag)this.itemOutputHandler.serializeNBT());
        pTag.m_128405_("progress", this.progress);
        pTag.m_128405_("progressMax", this.progressMax);
        super.m_183515_(pTag);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inv"));
        this.itemOutputHandler.deserializeNBT(pTag.m_128469_("output"));
        this.progress = pTag.m_128451_("progress");
        this.progressMax = pTag.m_128451_("progressMax");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ValoriaUtils.SUpdateTileEntityPacket(this);
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"menu.valoria.soul_infuser");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SoulInfuserMenu(pContainerId, this.f_58857_, this.m_58899_(), pPlayerInventory, pPlayer);
    }
}

