/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.block.entity.AbstractAltarBlockEntity;
import com.idark.valoria.registries.entity.living.boss.NecromancerEntity;
import com.idark.valoria.util.Pal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;

public class CrypticAltarBlockEntity
extends AbstractAltarBlockEntity {
    public CrypticAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.CRYPTIC_ALTAR.get(), pos, state);
    }

    @Override
    public void summonParticles(int tick) {
        double angle = ((double)tick + (double)this.progress * Math.PI) * 0.925;
        double y = angle * 0.01025;
        for (int a = 0; a < 3; ++a) {
            double radius = 0.5 * (1.0 - (double)this.progress / (double)this.progressMax) * (1.0 - (double)a * 2.5);
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.vividGreen, (Col)Col.darkGray).build()).setTransparencyData(GenericParticleData.create((float)0.125f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)((float)a * 0.125f), (float)0.1f, (float)0.0f).build()).setLifetime(35).spawn(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f) + x, (double)this.f_58858_.m_123342_() + (1.0 - (double)a / 1.25) + y, (double)((float)this.f_58858_.m_123343_() + 0.5f) + z);
        }
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)((float)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188501_()), (double)this.f_58858_.m_123342_() + 1.85 + y, (double)((float)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188501_()), (Math.random() - 0.5) * 0.1, Math.random() * 0.1, (Math.random() - 0.5) * 0.1);
    }

    @Override
    public SoundEvent getSummonSound() {
        return (SoundEvent)SoundsRegistry.NECROMANCER_SUMMON.get();
    }

    public NecromancerEntity getBoss(Level level) {
        return new NecromancerEntity((EntityType<? extends NecromancerEntity>)((EntityType)EntityTypeRegistry.NECROMANCER.get()), level);
    }

    @Override
    public void summonBoss(Level level) {
        NecromancerEntity boss = this.getBoss(level);
        boss.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (float)this.f_58858_.m_123342_() + 1.85f, (double)this.f_58858_.m_123343_() + 0.5, 0.0f, 0.0f);
        level.m_7967_((Entity)boss);
    }
}

