/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.block.types.CrushableBlock;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import pro.komaru.tridot.util.Tmp;

public class CrushableBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    private ItemStack item = ItemStack.f_41583_;
    @Nullable
    private Direction hitDirection;
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public CrushableBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntitiesRegistry.CRUSHABLE_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public boolean crushing(long pStartTick, Player pPlayer, Direction pHitDirection) {
        if (this.hitDirection == null) {
            this.hitDirection = pHitDirection;
        }
        this.brushCountResetsAtTick = pStartTick + 60L;
        if (pStartTick >= this.coolDownEndsAtTick && this.f_58857_ instanceof ServerLevel) {
            this.coolDownEndsAtTick = pStartTick + 10L;
            this.unpackLootTable(pPlayer);
            int i = this.getCompletionState();
            if (++this.brushCount >= 11) {
                this.brushingCompleted(pPlayer);
                return true;
            }
            this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 60);
            int j = this.getCompletionState();
            if (i != j) {
                BlockState blockstate = this.m_58900_();
                BlockState pState = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf(j));
                this.f_58857_.m_7731_(this.m_58899_(), pState, 3);
            }
            return false;
        }
        return false;
    }

    public void unpackLootTable(Player pPlayer) {
        if (this.lootTable != null && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(this.lootTable);
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)pPlayer;
                CriteriaTriggers.f_10563_.m_54597_(serverplayer, this.lootTable);
            }
            this.unpack(pPlayer, loottable);
        }
    }

    public void unpack(@Nullable Player pPlayer, LootTable loottable) {
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287239_(pPlayer != null ? pPlayer.m_36336_() : 0.0f).m_287235_(LootContextParamSets.f_81411_);
        ObjectArrayList objectarraylist = loottable.m_287214_(lootparams, this.lootTableSeed);
        this.item = switch (objectarraylist.size()) {
            case 0 -> ItemStack.f_41583_;
            case 1 -> (ItemStack)objectarraylist.get(0);
            default -> {
                LOGGER.warn("Expected max 1 loot from loot table {} got {}", (Object)this.lootTable, (Object)objectarraylist.size());
                yield (ItemStack)objectarraylist.get(0);
            }
        };
        this.lootTable = null;
        this.m_6596_();
    }

    private void brushingCompleted(Player pPlayer) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            Block block1;
            this.dropContent(pPlayer);
            BlockState blockstate = this.m_58900_();
            this.f_58857_.m_46796_(3008, this.m_58899_(), Block.m_49956_((BlockState)blockstate));
            Block block = this.m_58900_().m_60734_();
            if (block instanceof CrushableBlock) {
                CrushableBlock pBlock = (CrushableBlock)block;
                block1 = pBlock.getTurnsInto();
            } else {
                block1 = Blocks.f_50016_;
            }
            this.f_58857_.m_7731_(this.f_58858_, block1.m_49966_(), 3);
        }
    }

    private void dropContent(Player pPlayer) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.unpackLootTable(pPlayer);
            if (!this.item.m_41619_()) {
                double d0 = EntityType.f_20461_.m_20678_();
                double d1 = 1.0 - d0;
                double d2 = d0 / 2.0;
                Direction direction = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
                BlockPos blockpos = this.f_58858_.m_5484_(direction, 1);
                double d3 = (double)blockpos.m_123341_() + 0.5 * d1 + d2;
                double d4 = (double)blockpos.m_123342_() + 0.5 + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                double d5 = (double)blockpos.m_123343_() + 0.5 * d1 + d2;
                ItemEntity itementity = new ItemEntity(this.f_58857_, d3, d4, d5, this.item.m_41620_(this.f_58857_.f_46441_.m_188503_(21) + 10));
                itementity.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)itementity);
                this.item = ItemStack.f_41583_;
            }
        }
    }

    public void checkReset() {
        if (this.f_58857_ != null) {
            if (this.brushCount != 0 && this.f_58857_.m_46467_() >= this.brushCountResetsAtTick) {
                int i = this.getCompletionState();
                this.brushCount = Math.max(0, this.brushCount - 2);
                int j = this.getCompletionState();
                if (i != j) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf(j)), 3);
                }
                this.brushCountResetsAtTick = this.f_58857_.m_46467_() + 4L;
            }
            if (this.brushCount == 0) {
                this.hitDirection = null;
                this.brushCountResetsAtTick = 0L;
                this.coolDownEndsAtTick = 0L;
            } else {
                this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), (int)(this.brushCountResetsAtTick - this.f_58857_.m_46467_()));
            }
        }
    }

    private boolean tryLoadLootTable(CompoundTag pTag) {
        if (pTag.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(pTag.m_128461_("LootTable"));
            this.lootTableSeed = pTag.m_128454_("LootTableSeed");
            return true;
        }
        return false;
    }

    private boolean trySaveLootTable(CompoundTag pTag) {
        if (this.lootTable == null) {
            return false;
        }
        pTag.m_128359_("LootTable", this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            pTag.m_128356_("LootTableSeed", this.lootTableSeed);
        }
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = super.m_5995_();
        if (this.hitDirection != null) {
            compoundtag.m_128405_("hit_direction", this.hitDirection.ordinal());
        }
        compoundtag.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        return compoundtag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag pTag) {
        if (!this.tryLoadLootTable(pTag) && pTag.m_128441_("item")) {
            this.item = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("item"));
        }
        if (pTag.m_128441_("hit_direction")) {
            this.hitDirection = Direction.values()[pTag.m_128451_("hit_direction")];
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        if (!this.trySaveLootTable(pTag)) {
            pTag.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        }
    }

    public static void setLootTable(BlockGetter pLevel, RandomSource pRandom, BlockPos pPos, ResourceLocation pLootTable) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof CrushableBlockEntity) {
            CrushableBlockEntity entity = (CrushableBlockEntity)blockentity;
            entity.setLootTable(pLootTable, pRandom.m_188505_());
        }
    }

    public static void setLootTable(RandomSource pRandom, BlockEntity blockentity, ResourceLocation pLootTable) {
        if (blockentity instanceof CrushableBlockEntity) {
            CrushableBlockEntity entity = (CrushableBlockEntity)blockentity;
            entity.setLootTable(pLootTable, pRandom.m_188505_());
        }
    }

    public static void unpackAndSetItem(ServerLevel pLevel, BlockEntity blockentity, LootTable loottable) {
        if (blockentity instanceof CrushableBlockEntity) {
            CrushableBlockEntity entity = (CrushableBlockEntity)blockentity;
            LootParams lootparams = new LootParams.Builder(pLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)entity.f_58858_)).m_287239_(0.0f).m_287235_(LootContextParamSets.f_81411_);
            ObjectArrayList objectarraylist = loottable.m_287214_(lootparams, Tmp.rnd.nextLong());
            entity.setItem((ItemStack)objectarraylist.get(0));
            entity.m_6596_();
        }
    }

    public static void setItem(BlockGetter pLevel, BlockPos pPos, ItemStack pItem) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof CrushableBlockEntity) {
            CrushableBlockEntity entity = (CrushableBlockEntity)blockentity;
            entity.setItem(pItem);
        }
    }

    public void setLootTable(ResourceLocation pLootTable, long pLootTableSeed) {
        this.lootTable = pLootTable;
        this.lootTableSeed = pLootTableSeed;
    }

    public void setItem(ItemStack pItem) {
        this.item = pItem;
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        return this.brushCount < 6 ? 2 : 3;
    }

    @Nullable
    public Direction getHitDirection() {
        return this.hitDirection;
    }

    public ItemStack getItem() {
        return this.item;
    }
}

