/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.MiscRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.item.types.SummonBook;
import com.idark.valoria.registries.item.types.consumables.PlaceableDrinkItem;
import com.idark.valoria.registries.item.types.consumables.ValoriaFood;
import com.idark.valoria.registries.item.types.curio.AbstractTalismanItem;
import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.entity.AbstractMinionEntity;
import pro.komaru.tridot.common.registry.item.types.AbstractConsumableItem;
import pro.komaru.tridot.util.Col;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="valoria", bus=Mod.EventBusSubscriber.Bus.MOD)
public abstract class ItemTabRegistry {
    private static final Comparator<Holder<PaintingVariant>> PAINTING_COMPARATOR = Comparator.comparing(Holder::m_203334_, Comparator.comparingInt(p_270004_ -> p_270004_.m_218909_() * p_270004_.m_218908_()).thenComparing(PaintingVariant::m_218908_));
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"valoria");
    public static final RegistryObject<CreativeModeTab> VALORIA_BLOCKS_TAB = CREATIVE_MODE_TABS.register("valoria_blocks", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)BlockRegistry.jewelerTable.get())).m_257809_().m_257941_((Component)Component.m_237115_((String)"itemGroup.valoriaBlocksModTab")).withTabsImage(ItemTabRegistry.getTabsImage()).m_257609_("valoria_item.png").withBackgroundLocation(ItemTabRegistry.getBackgroundImage()).m_257652_());
    public static final RegistryObject<CreativeModeTab> VALORIA_TAB = CREATIVE_MODE_TABS.register("valoria_misc", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ItemsRegistry.pumpkinBomb.get())).m_257809_().m_257941_((Component)Component.m_237115_((String)"itemGroup.valoriaMiscModTab")).withTabsImage(ItemTabRegistry.getTabsImage()).withTabsAfter(new ResourceKey[]{VALORIA_TOOLS.getKey()}).m_257609_("valoria_item.png").withBackgroundLocation(ItemTabRegistry.getBackgroundImage()).m_257652_());
    public static final RegistryObject<CreativeModeTab> VALORIA_TOOLS = CREATIVE_MODE_TABS.register("valoria_tools", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ItemsRegistry.dreadAxe.get())).m_257809_().m_257941_((Component)Component.m_237115_((String)"itemGroup.valoriaToolsModTab")).withTabsImage(ItemTabRegistry.getTabsImage()).withTabsAfter(new ResourceKey[]{VALORIA_CONSUMABLES.getKey()}).m_257609_("valoria_item.png").withBackgroundLocation(ItemTabRegistry.getBackgroundImage()).m_257652_());
    public static final RegistryObject<CreativeModeTab> VALORIA_CONSUMABLES = CREATIVE_MODE_TABS.register("valoria_consumables", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ItemsRegistry.candyCorn.get())).m_257809_().m_257941_((Component)Component.m_237115_((String)"itemGroup.valoriaConsumablesModTab")).withTabsImage(ItemTabRegistry.getTabsImage()).withTabsAfter(new ResourceKey[]{VALORIA_ARMOR_TAB.getKey()}).m_257609_("valoria_item.png").withBackgroundLocation(ItemTabRegistry.getBackgroundImage()).m_257652_());
    public static final RegistryObject<CreativeModeTab> VALORIA_ARMOR_TAB = CREATIVE_MODE_TABS.register("valoria_armor", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ItemsRegistry.etherealHelmet.get())).m_257809_().m_257941_((Component)Component.m_237115_((String)"itemGroup.valoriaArmorModTab")).withTabsImage(ItemTabRegistry.getTabsImage()).withTabsAfter(new ResourceKey[]{VALORIA_ACCESSORIES_TAB.getKey()}).m_257609_("valoria_item.png").withBackgroundLocation(ItemTabRegistry.getBackgroundImage()).m_257652_());
    public static final RegistryObject<CreativeModeTab> VALORIA_ACCESSORIES_TAB = CREATIVE_MODE_TABS.register("valoria_accessories", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ItemsRegistry.goldenRingRuby.get())).m_257809_().m_257941_((Component)Component.m_237115_((String)"itemGroup.valoriaAccessoriesModTab")).withTabsImage(ItemTabRegistry.getTabsImage()).withTabsAfter(new ResourceKey[]{VALORIA_BLOCKS_TAB.getKey()}).m_257609_("valoria_item.png").withBackgroundLocation(ItemTabRegistry.getBackgroundImage()).m_257652_());

    public static ResourceLocation getBackgroundImage() {
        return new ResourceLocation("valoria", "textures/gui/container/tab_valoria_item_legacy.png");
    }

    public static ResourceLocation getTabsImage() {
        return new ResourceLocation("valoria", "textures/gui/container/tabs_valoria_legacy.png");
    }

    public static void register(IEventBus eventBus) {
        CREATIVE_MODE_TABS.register(eventBus);
    }

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        BiConsumer<Predicate, Boolean> addItems = (filter, fromBlocks) -> {
            Collection entries = fromBlocks != false ? ItemsRegistry.BLOCK_ITEMS.getEntries() : ItemsRegistry.ITEMS.getEntries();
            for (RegistryObject item : entries) {
                Item i = (Item)item.get();
                if (new ItemStack((ItemLike)i).m_204117_(TagsRegistry.EXCLUDED_FROM_TAB) || !filter.test(i)) continue;
                event.m_246342_(i.m_7968_());
            }
        };
        if (tabKey == VALORIA_BLOCKS_TAB.getKey()) {
            addItems.accept(i -> true, true);
            event.getParameters().f_268485_().m_254861_(MiscRegistry.PAINTING_TYPES.getRegistryKey()).ifPresent(paintings -> ItemTabRegistry.generatePresetPaintings((CreativeModeTab.Output)event, (HolderLookup.RegistryLookup<PaintingVariant>)paintings, holder -> holder.m_203656_(TagsRegistry.MODDED), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
        } else if (tabKey == VALORIA_TAB.getKey()) {
            addItems.accept(i -> !ItemTabRegistry.isAccessory(i) && !ItemTabRegistry.isArmor(i) && !(i instanceof SummonBook) && !ItemTabRegistry.isTool(i) && !ItemTabRegistry.isConsumable(i), false);
        } else if (tabKey == VALORIA_CONSUMABLES.getKey()) {
            addItems.accept(ItemTabRegistry::isConsumable, false);
        } else if (tabKey == VALORIA_TOOLS.getKey()) {
            if (Utils.isDevelopment) {
                event.accept(ItemsRegistry.debugItem);
            }
            addItems.accept(ItemTabRegistry::isTool, false);
            event.getParameters().f_268485_().m_254861_(ForgeRegistries.ENTITY_TYPES.getRegistryKey()).ifPresent(entities -> ItemTabRegistry.generateMinionItems((CreativeModeTab.Output)event, entities, holder -> holder.m_203656_(TagsRegistry.MINIONS), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
        } else if (tabKey == VALORIA_ARMOR_TAB.getKey()) {
            addItems.accept(ItemTabRegistry::isArmor, false);
        } else if (tabKey == VALORIA_ACCESSORIES_TAB.getKey()) {
            addItems.accept(ItemTabRegistry::isAccessory, false);
        }
    }

    public static boolean isArmor(Item i) {
        return i instanceof ArmorItem;
    }

    public static boolean isAccessory(Item i) {
        return i instanceof ICurioItem || i instanceof AbstractTalismanItem || i.m_7968_().m_204117_(Tags.Items.TOOLS_SHIELDS);
    }

    public static boolean isTool(Item i) {
        return i.m_7968_().m_204117_(ItemTags.f_271540_) || i.m_7968_().m_204117_(Tags.Items.TOOLS) || i.m_7968_().m_204117_(Tags.Items.TOOLS_CROSSBOWS) || i.m_7968_().m_204117_(Tags.Items.TOOLS_BOWS);
    }

    public static boolean isConsumable(Item i) {
        return i instanceof AbstractConsumableItem || i instanceof ValoriaFood || i instanceof PlaceableDrinkItem || i.m_41472_();
    }

    private static void generateMinionItems(CreativeModeTab.Output output, HolderLookup.RegistryLookup<EntityType<?>> entityLookup, Predicate<Holder<EntityType<?>>> predicate, CreativeModeTab.TabVisibility visibility) {
        output.m_246342_(new ItemStack((ItemLike)ItemsRegistry.summonBook.get()));
        entityLookup.m_214062_().filter(predicate).forEach(holder -> {
            ItemStack itemStack = new ItemStack((ItemLike)ItemsRegistry.summonBook.get());
            CompoundTag tag = itemStack.m_41698_("EntityTag");
            SummonBook.storeVariant(tag, holder);
            SummonBook.setColor(itemStack, Col.colorToDecimal((Color)AbstractMinionEntity.getColor((EntityType)((EntityType)holder.get()))));
            output.m_246267_(itemStack, visibility);
        });
    }

    private static void generatePresetPaintings(CreativeModeTab.Output pOutput, HolderLookup.RegistryLookup<PaintingVariant> pPaintingVariants, Predicate<Holder<PaintingVariant>> pPredicate, CreativeModeTab.TabVisibility pTabVisibility) {
        pPaintingVariants.m_214062_().filter(pPredicate).sorted(PAINTING_COMPARATOR).forEach(p_269979_ -> {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42487_);
            CompoundTag compoundtag = itemstack.m_41698_("EntityTag");
            Painting.m_269220_((CompoundTag)compoundtag, (Holder)p_269979_);
            pOutput.m_246267_(itemstack, pTabVisibility);
        });
    }
}

