/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.util.Pal;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class SoulCollectParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final UUID uuid;

    public SoulCollectParticlePacket(UUID uuid, double posX, double posY, double posZ) {
        this.uuid = uuid;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static SoulCollectParticlePacket decode(FriendlyByteBuf buf) {
        return new SoulCollectParticlePacket(buf.m_130259_(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(SoulCollectParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                Vec3 pos = new Vec3(msg.posX, msg.posY, msg.posZ);
                Consumer<GenericParticle> blockTarget = p -> {
                    Player player = level.m_46003_(msg.uuid);
                    Vec3 pPos = p.getPosition();
                    if (player != null) {
                        double dX = player.m_20185_() - pPos.m_7096_();
                        double dY = player.m_20186_() - pPos.m_7098_();
                        double dZ = player.m_20189_() - pPos.m_7094_();
                        double yaw = Math.atan2(dZ, dX);
                        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                        float speed = 0.01f;
                        float x = (float)(Math.sin(pitch) * Math.cos(yaw) * (double)speed);
                        float y = (float)(Math.cos(pitch) * (double)speed);
                        float z = (float)(Math.sin(pitch) * Math.sin(yaw) * (double)speed);
                        p.setSpeed(p.getSpeed().m_82492_((double)x, (double)y, (double)z));
                    }
                };
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SKULL).setColorData(ColorParticleData.create((Col)Pal.cyan, (Col)Col.white).build()).setTransparencyData(GenericParticleData.create((float)0.3f).setEasing(Interp.circle).build()).setScaleData(GenericParticleData.create((float)0.06f, (float)0.15f, (float)0.0f).setEasing(Interp.circle).build()).addTickActor(blockTarget).setLifetime(65).randomVelocity(0.25)).disablePhysics().repeat(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 8);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }
}

