/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.util.Col;

public class ParticleLinePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final float posToX;
    private final float posToY;
    private final float posToZ;
    private final int colorR;
    private final int colorG;
    private final int colorB;
    private final int colorToR;
    private final int colorToG;
    private final int colorToB;

    public ParticleLinePacket(double posX, double posY, double posZ, float posToX, float posToY, float posToZ, int colorR, int colorG, int colorB, int colorToR, int colorToG, int colorToB) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.posToX = posToX;
        this.posToY = posToY;
        this.posToZ = posToZ;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
        this.colorToR = colorToR;
        this.colorToG = colorToG;
        this.colorToB = colorToB;
    }

    public static ParticleLinePacket decode(FriendlyByteBuf buf) {
        return new ParticleLinePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(ParticleLinePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                Vec3 pos = new Vec3(msg.posX, msg.posY, msg.posZ);
                Vec3 pTo = new Vec3((double)msg.posToX, (double)msg.posToY, (double)msg.posToZ);
                double distance = pos.m_82554_(pTo);
                double distanceInBlocks = Math.floor(distance);
                int i = 0;
                while ((double)i < distanceInBlocks) {
                    double dX = msg.posX - pTo.f_82479_;
                    double dY = msg.posY - pTo.f_82480_;
                    double dZ = msg.posZ - pTo.f_82481_;
                    float x = (float)(dX / distanceInBlocks);
                    float y = (float)(dY / distanceInBlocks);
                    float z = (float)(dZ / distanceInBlocks);
                    Vec3 particlePos = new Vec3(pTo.f_82479_ + (double)(x * (float)i), pTo.f_82480_ + (double)0.2f + (double)(y * (float)i), pTo.f_82481_ + (double)(z * (float)i));
                    Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                    ParticleEffects.particles(pLevel, particlePos, ColorParticleData.create((Col)color, (Col)Col.white).build());
                    ++i;
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.posToX);
        buf.writeFloat(this.posToY);
        buf.writeFloat(this.posToZ);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
        buf.writeInt(this.colorToR);
        buf.writeInt(this.colorToG);
        buf.writeInt(this.colorToB);
    }
}

