/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.util.Pal;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class MinionSummonParticlePacket {
    private final int id;
    private final BlockPos pos;

    public MinionSummonParticlePacket(int id, BlockPos pos) {
        this.id = id;
        this.pos = pos;
    }

    public static MinionSummonParticlePacket decode(FriendlyByteBuf buf) {
        return new MinionSummonParticlePacket(buf.readInt(), buf.m_130135_());
    }

    public static void handle(MinionSummonParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                Consumer<GenericParticle> blockTarget = p -> {
                    Entity entity = pLevel.m_6815_(msg.id);
                    if (entity == null) {
                        return;
                    }
                    Vec3 entityPos = entity.m_20182_();
                    Vec3 pPos = p.getPosition();
                    double dX = entityPos.f_82479_ - pPos.m_7096_();
                    double dY = entityPos.f_82480_ - pPos.m_7098_();
                    double dZ = entityPos.f_82481_ - pPos.m_7094_();
                    double yaw = Math.atan2(dZ, dX);
                    double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                    float speed = 0.01f;
                    float x = (float)(Math.sin(pitch) * Math.cos(yaw) * (double)speed);
                    float y = (float)(Math.cos(pitch) * (double)speed);
                    float z = (float)(Math.sin(pitch) * Math.sin(yaw) * (double)speed);
                    p.setSpeed(p.getSpeed().m_82492_((double)x, (double)y, (double)z));
                };
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.DOT).setColorData(ColorParticleData.create((Col)Pal.vividGreen, (Col)Pal.amethyst).build()).setTransparencyData(GenericParticleData.create((float)0.3f).setEasing((Interp)Interp.bounce).build()).setScaleData(GenericParticleData.create((float)0.045f, (float)0.075f, (float)0.0f).setEasing(Interp.circleOut).build()).addTickActor(blockTarget).setLifetime(85).randomVelocity((double)0.15f)).disablePhysics().repeat(pLevel, (double)msg.pos.m_123341_(), (double)msg.pos.m_123342_(), (double)msg.pos.m_123343_(), 6);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.m_130064_(this.pos);
    }
}

