/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.util.Col;

public class LineToNearbyMobsParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final float yawRaw;
    private final float rad;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public LineToNearbyMobsParticlePacket(double posX, double posY, double posZ, float yawRaw, float radius, int colorR, int colorG, int colorB) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.yawRaw = yawRaw;
        this.rad = radius;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public static LineToNearbyMobsParticlePacket decode(FriendlyByteBuf buf) {
        return new LineToNearbyMobsParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(LineToNearbyMobsParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                double pitch = 1.5707963267948966;
                double yaw = (double)(msg.yawRaw + 90.0f) * Math.PI / 180.0;
                ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
                double locYaw = 0.0;
                double locPitch = 0.0;
                double X = Math.sin(locPitch + pitch) * Math.cos(locYaw + yaw) * (double)msg.rad;
                double Y = Math.cos(locPitch + pitch) * (double)msg.rad;
                double Z = Math.sin(locPitch + pitch) * Math.sin(locYaw + yaw) * (double)msg.rad;
                AABB boundingBox = new AABB(msg.posX, msg.posY - 8.0 + (Math.random() - 0.5) * (double)0.2f, msg.posZ, msg.posX + X, msg.posY + Y + (Math.random() - 0.5) * (double)0.2f, msg.posZ + Z);
                List entities = pLevel.m_45976_(Entity.class, boundingBox);
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity)) continue;
                    hitEntities.add(livingEntity);
                    if (!livingEntity.m_6084_()) continue;
                    Vec3 pos = new Vec3(msg.posX, msg.posY, msg.posZ);
                    Vec3 pTo = new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                    Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                    double distance = pos.m_82554_(pTo);
                    double distanceInBlocks = Math.floor(distance);
                    int i = 0;
                    while ((double)i < distanceInBlocks) {
                        double dX = msg.posX - pTo.f_82479_;
                        double dY = msg.posY - pTo.f_82480_;
                        double dZ = msg.posZ - pTo.f_82481_;
                        float x = (float)(dX / distanceInBlocks);
                        float y = (float)(dY / distanceInBlocks);
                        float z = (float)(dZ / distanceInBlocks);
                        Vec3 particlePos = new Vec3(pos.f_82479_ - (double)(x * (float)i), pos.f_82480_ + (double)0.2f - (double)(y * (float)i), pos.f_82481_ - (double)(z * (float)i));
                        ParticleEffects.particles(pLevel, particlePos, ColorParticleData.create((Col)color, (Col)Col.white).build());
                        ++i;
                    }
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.yawRaw);
        buf.writeFloat(this.rad);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

