/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.util.Col;

public class CircleShapedParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final float yawRaw;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public CircleShapedParticlePacket(double posX, double posY, double posZ, float yawRaw, int colorR, int colorG, int colorB) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.yawRaw = yawRaw;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public static CircleShapedParticlePacket decode(FriendlyByteBuf buf) {
        return new CircleShapedParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(CircleShapedParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                float pRadius = 1.0f;
                double pitch = 1.5707963267948966;
                Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                for (int i = 0; i < 360; i += 10) {
                    double yaw = (double)(msg.yawRaw + 90.0f + (float)i) * Math.PI / 180.0;
                    double X = Math.sin(pitch) * Math.cos(yaw) * (double)pRadius * 0.75;
                    double Y = Math.cos(pitch) * (double)pRadius * 0.75;
                    double Z = Math.sin(pitch) * Math.sin(yaw) * (double)pRadius * 0.75;
                    Vec3 pos = new Vec3(msg.posX + X, msg.posY + Y * (double)0.2f, msg.posZ + Z);
                    ParticleEffects.particles(level, pos, ColorParticleData.create((Col)color, (Col)Col.black).build());
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.yawRaw);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

