/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleRegistry;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class BeastAttackParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public BeastAttackParticlePacket(double posX, double posY, double posZ, Color color) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.colorR = color.getRed();
        this.colorG = color.getGreen();
        this.colorB = color.getBlue();
    }

    public static BeastAttackParticlePacket decode(FriendlyByteBuf buf) {
        return new BeastAttackParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), new Color(buf.readInt(), buf.readInt(), buf.readInt()));
    }

    public static void handle(BeastAttackParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create(ParticleRegistry.SMOKE).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE).setColorData(ColorParticleData.create((Col)color, (Col)color.darker()).setEasing((Interp)Interp.bounceIn).build()).setTransparencyData(GenericParticleData.create().setRandomValue(1.0f, 0.0f).setEasing(Interp.sineOut).build()).setScaleData(GenericParticleData.create((float)0.7f, (float)0.4f, (float)0.0f).build()).setLifetime(95 + level.f_46441_.m_188503_(100)).randomVelocity(0.05, 0.15, 0.05)).randomOffset((double)0.025f)).spawn(level, msg.posX, msg.posY, msg.posZ);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

