/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosSetStackPacket {
    private final ItemStack stack;

    public CuriosSetStackPacket(ItemStack stack) {
        this.stack = stack.m_41777_();
    }

    public static CuriosSetStackPacket decode(FriendlyByteBuf buf) {
        return new CuriosSetStackPacket(buf.m_130267_());
    }

    public static void handle(CuriosSetStackPacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (!ctx.get().getDirection().getReceptionSide().isServer()) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            CuriosApi.getCurio((ItemStack)msg.stack).ifPresent(curio -> CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                for (Map.Entry entry : handler.getCurios().entrySet()) {
                    SlotContext slotContext;
                    int i;
                    NonNullList renderStates = ((ICurioStacksHandler)entry.getValue()).getRenders();
                    IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                    for (i = 0; i < stackHandler.getSlots(); ++i) {
                        slotContext = new SlotContext((String)entry.getKey(), (LivingEntity)player, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                        for (ItemStack toEquip : player.m_150109_().f_35974_) {
                            if (!toEquip.equals(msg.stack, false) || !stackHandler.getStackInSlot(i).m_41619_() || !stackHandler.isItemValid(i, msg.stack) || !curio.canEquip(slotContext)) continue;
                            CuriosSetStackPacket.setCurio(curio, toEquip, stackHandler, i, slotContext, player);
                            return;
                        }
                    }
                    for (i = 0; i < stackHandler.getSlots(); ++i) {
                        slotContext = new SlotContext((String)entry.getKey(), (LivingEntity)player, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                        ItemStack currentCurioStack = stackHandler.getStackInSlot(i);
                        for (ItemStack toEquip : player.m_150109_().f_35974_) {
                            if (!toEquip.equals(msg.stack, false) || !currentCurioStack.m_41619_() && !toEquip.m_41784_().toString().equals(msg.stack.m_41784_().toString()) || !stackHandler.isItemValid(i, msg.stack) || !curio.canEquip(slotContext)) continue;
                            CuriosSetStackPacket.equipCurio(curio, toEquip, currentCurioStack, slotContext, player, stackHandler, i);
                            return;
                        }
                    }
                }
            }));
        });
        ctx.get().setPacketHandled(true);
    }

    private static void equipCurio(ICurio curio, ItemStack toEquip, ItemStack currentCurioStack, SlotContext slotContext, ServerPlayer player, IDynamicStackHandler stackHandler, int i) {
        ICurioItem currentCurio;
        if (!currentCurioStack.m_41619_() && (currentCurio = (ICurioItem)currentCurioStack.m_41720_()).canUnequip(slotContext, currentCurioStack)) {
            player.m_150109_().m_6836_(player.m_150109_().m_36030_(toEquip), currentCurioStack);
            currentCurio.onUnequip(slotContext, toEquip, currentCurioStack);
            stackHandler.extractItem(i, currentCurioStack.m_41613_(), false);
            CuriosSetStackPacket.setCurio(curio, toEquip, stackHandler, i, slotContext, player);
        }
    }

    private static void setCurio(ICurio curio, ItemStack item, IDynamicStackHandler stackHandler, int i, SlotContext slotContext, ServerPlayer player) {
        stackHandler.insertItem(i, item, false);
        curio.onEquipFromUse(slotContext);
        player.m_150109_().m_36057_(item);
    }

    public static void encode(CuriosSetStackPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130055_(msg.stack);
    }
}

