/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public abstract class CoreStateGen
extends BlockStateProvider {
    public String id;

    public CoreStateGen(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
        this.id = modid;
    }

    public void registerKit(Block stairs, Block slab, Block texture) {
        this.stairsBlock((StairBlock)stairs, this.blockTexture(texture));
        this.registerSlab(slab, texture);
        this.blockItem(stairs);
    }

    public void wallBlock(WallBlock block, ResourceLocation texture) {
        this.wallBlock(block, this.key((Block)block).toString(), texture);
        ((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)block).m_135815_())).parent((ModelFile)this.models().wallInventory(this.key((Block)block) + "_inventory", texture));
    }

    public void registerKit(Block block, Block stairs, Block slab, Block wall) {
        this.blockWithItem(block);
        this.wallBlock((WallBlock)wall, this.blockTexture(block));
        this.registerKit(stairs, slab, block);
    }

    public void registerSlab(Block slab, Block texture) {
        this.slabBlock((SlabBlock)slab, this.blockTexture(texture), this.blockTexture(texture));
        this.blockItem(slab);
    }

    public void registerDoor(Block door) {
        this.doorBlock((DoorBlock)door, this.sided(door, "_bottom"), this.sided(door, "_top"));
    }

    public ResourceLocation sided(Block block, String side) {
        return new ResourceLocation(this.id, ":block/" + this.key(block).m_135815_() + side);
    }

    public void saplingBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.key((Block)blockRegistryObject.get()).m_135815_(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    public String name(Block block) {
        return this.key(block).m_135815_();
    }

    public ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public void leavesBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.key((Block)blockRegistryObject.get()).m_135815_(), new ResourceLocation("minecraft:block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    public void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.id + ":block/" + this.key(block).m_135815_()));
    }

    public void blockWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    public void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }
}

