/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.compat.jei.categories;

import com.idark.valoria.core.compat.jei.ModRecipeTypes;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.item.recipe.KilnRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class KilnRecipeCategory
extends AbstractRecipeCategory<KilnRecipe> {
    protected final int regularCookTime;

    public KilnRecipeCategory(IGuiHelper helper, int regularCookTime) {
        super(ModRecipeTypes.KILN, (Component)Component.m_237115_((String)"jei.valoria.kiln"), helper.createDrawableItemLike((ItemLike)BlockRegistry.kiln.get()), 82, 54);
        this.regularCookTime = regularCookTime;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, KilnRecipe recipeHolder, IFocusGroup focuses) {
        builder.addInputSlot(1, 1).setStandardSlotBackground().addIngredients((Ingredient)recipeHolder.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addOutputSlot(61, 19).setOutputSlotBackground().addItemStack(recipeHolder.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, KilnRecipe recipeHolder, IFocusGroup focuses) {
        int cookTime = recipeHolder.m_43753_();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        builder.addAnimatedRecipeArrow(cookTime).setPosition(26, 17);
        builder.addAnimatedRecipeFlame(300).setPosition(1, 20);
        this.addExperience(builder, recipeHolder);
        this.addCookTime(builder, recipeHolder);
    }

    protected void addExperience(IRecipeExtrasBuilder builder, KilnRecipe recipeHolder) {
        float experience = recipeHolder.m_43750_();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            ((ITextWidget)builder.addText((FormattedText)experienceString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        }
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, KilnRecipe recipeHolder) {
        int cookTime = recipeHolder.m_43753_();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            ((ITextWidget)builder.addText((FormattedText)timeString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
        }
    }

    public ResourceLocation getRegistryName(KilnRecipe recipe) {
        return recipe.m_6423_();
    }
}

