/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.capability;

import com.idark.valoria.api.unlockable.Unlockables;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.core.capability.IUnlockable;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class UnlockableProvider
implements IUnlockable,
INBTSerializable<CompoundTag> {
    Set<Unlockable> unlockables = new HashSet<Unlockable>();
    Set<Unlockable> claimed = new HashSet<Unlockable>();

    @Override
    public boolean isUnlocked(Unlockable unlockable) {
        return this.unlockables.contains(unlockable);
    }

    @Override
    public boolean isClaimed(Unlockable unlockable) {
        return this.claimed.contains(unlockable);
    }

    @Override
    public void claim(Unlockable unlockable) {
        this.claimed.add(unlockable);
    }

    @Override
    public void clearClaimed() {
        this.claimed.clear();
    }

    @Override
    public void addUnlockable(Unlockable unlockable) {
        this.unlockables.add(unlockable);
    }

    @Override
    public void removeUnlockable(Unlockable unlockable) {
        this.unlockables.remove(unlockable);
    }

    @Override
    public void addAllUnlockable() {
        this.unlockables.clear();
        this.unlockables.addAll(Unlockables.get());
    }

    @Override
    public void removeAllUnlockable() {
        this.unlockables.clear();
    }

    @Override
    public Set<Unlockable> getClaimed() {
        return this.claimed;
    }

    @Override
    public Set<Unlockable> getUnlockables() {
        return this.unlockables;
    }

    public CompoundTag serializeNBT() {
        ListTag unlocked = new ListTag();
        ListTag claimed = new ListTag();
        for (Unlockable un0 : this.getUnlockables()) {
            if (un0 == null) continue;
            unlocked.add((Object)StringTag.m_129297_((String)un0.getId()));
        }
        for (Unlockable un1 : this.getClaimed()) {
            if (un1 == null) continue;
            claimed.add((Object)StringTag.m_129297_((String)un1.getId()));
        }
        CompoundTag wrapper = new CompoundTag();
        wrapper.m_128365_("unlocked", (Tag)unlocked);
        wrapper.m_128365_("claimed", (Tag)claimed);
        return wrapper;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Unlockable unlockable;
        int i;
        this.removeAllUnlockable();
        if (nbt.m_128441_("unlocked")) {
            ListTag unlockables = nbt.m_128437_("unlocked", 8);
            for (i = 0; i < unlockables.size(); ++i) {
                unlockable = Unlockables.getUnlockable(unlockables.m_128778_(i));
                if (unlockable == null) continue;
                this.addUnlockable(unlockable);
            }
        }
        this.clearClaimed();
        if (nbt.m_128441_("claimed")) {
            ListTag claimed = nbt.m_128437_("claimed", 8);
            for (i = 0; i < claimed.size(); ++i) {
                unlockable = Unlockables.getUnlockable(claimed.m_128778_(i));
                if (unlockable == null) continue;
                this.claim(unlockable);
            }
        }
    }
}

