/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book.codex.checklist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.idark.valoria.Valoria;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntries;
import com.idark.valoria.client.ui.screen.book.codex.checklist.BossEntry;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class BossEntryLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    public static final BossEntryLoader INSTANCE = new BossEntryLoader();

    public BossEntryLoader() {
        super(GSON, "bosses");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        Valoria.LOGGER.info("Reloading Bosses info...");
        CodexEntries.bossEntries.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            JsonObject json = entry.getValue().getAsJsonObject();
            BossEntry.BossEntryData data = (BossEntry.BossEntryData)GSON.fromJson((JsonElement)json, BossEntry.BossEntryData.class);
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(data.entity));
            BossEntry boss = new BossEntry((EntityType<? extends LivingEntity>)type);
            if (data.name != null) {
                boss.name = Component.m_237115_((String)data.name);
            }
            if (data.description != null) {
                boss.description = Component.m_237115_((String)data.description);
            }
            if (data.category != null) {
                boss.category = data.category;
            }
            if (data.item != null) {
                boss.summonItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.item));
            }
            boss.setUnlocked(data.is_unlocked);
            CodexEntries.bossEntries.add((Object)boss);
        }
    }
}

