/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book.codex;

import com.google.common.collect.Lists;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.client.ui.screen.book.Chapter;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntry;
import com.idark.valoria.client.ui.screen.book.codex.Style;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.util.struct.data.Seq;

public class ChapterNode {
    public Chapter chapter;
    public Item item;
    public Seq<ChapterNode> children = Seq.with();
    public Unlockable unlockable;
    public Style style;
    public CodexEntry entry;
    public List<Component> description = Lists.newArrayList();
    public List<Component> hints = Lists.newArrayList();

    public ChapterNode(Chapter chapter, Item item) {
        this(chapter, item, Style.STANDARD, null);
    }

    public ChapterNode(Chapter chapter, Item item, Style style) {
        this(chapter, item, style, null);
    }

    public ChapterNode(Chapter chapter, Item item, Style style, Unlockable unlockable) {
        this.chapter = chapter;
        this.item = item;
        this.unlockable = unlockable;
        this.style = style;
    }

    public ChapterNode(Chapter chapter, Item item, Unlockable unlockable) {
        this.chapter = chapter;
        this.item = item;
        this.unlockable = unlockable;
        this.style = Style.STANDARD;
    }

    public ChapterNode setUnknownName(String key) {
        this.chapter.setUnknownKey(key);
        return this;
    }

    public ChapterNode addHintsDescription(MutableComponent ... components) {
        Collections.addAll(this.hints, components);
        return this;
    }

    public ChapterNode addDescription(MutableComponent ... components) {
        Collections.addAll(this.description, components);
        return this;
    }

    public ChapterNode addChild(ChapterNode node) {
        this.children.add((Object)node);
        return this;
    }

    public ChapterNode addChild(Chapter chapter, Item item) {
        return this.addChild(new ChapterNode(chapter, item));
    }

    public ChapterNode addChild(Chapter chapter, Item item, Unlockable unlockable) {
        return this.addChild(new ChapterNode(chapter, item, unlockable));
    }

    public ChapterNode addChild(Chapter chapter, RegistryObject<Item> item) {
        return this.addChild(new ChapterNode(chapter, (Item)item.get()));
    }

    public ChapterNode addChild(Chapter chapter, RegistryObject<Item> item, Unlockable unlockable) {
        return this.addChild(new ChapterNode(chapter, (Item)item.get(), unlockable));
    }
}

