/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen;

import com.idark.valoria.client.ui.menus.TinkererMenu;
import com.idark.valoria.registries.item.recipe.TinkeringRecipe;
import com.idark.valoria.util.Pal;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

@OnlyIn(value=Dist.CLIENT)
public class TinkeringScreen
extends AbstractContainerScreen<TinkererMenu> {
    private final ResourceLocation BG_LOCATION = new ResourceLocation("valoria", "textures/gui/container/tinkering.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public TinkeringScreen(TinkererMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        screenContainer.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
        this.f_97727_ = 165;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(pGuiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        pGuiGraphics.m_280218_(this.BG_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        pGuiGraphics.m_280218_(this.BG_LOCATION, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(pGuiGraphics, pMouseX, pMouseY, l, i1, j1);
        this.renderRecipes(pGuiGraphics, l, i1, j1);
    }

    private void renderFloatingItem(GuiGraphics pGuiGraphics, ItemStack pStack, int pX, int pY) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 232.0f);
        pGuiGraphics.m_280480_(pStack, pX, pY);
        Font font = IClientItemExtensions.of((ItemStack)pStack).getFont(pStack, IClientItemExtensions.FontContext.ITEM_COUNT);
        pGuiGraphics.m_280302_(font == null ? this.f_96547_ : font, pStack, pX, pY, String.valueOf(pStack.m_41613_()));
        pGuiGraphics.m_280168_().m_85849_();
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            List<TinkeringRecipe> list = ((TinkererMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < ((TinkererMenu)this.f_97732_).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (pX < j1 || pX >= j1 + 16 || pY < k1 || pY >= k1 + 18) continue;
                ItemStack stack = ((TinkererMenu)this.f_97732_).container.m_8020_(0).m_41777_();
                if (((TinkererMenu)this.f_97732_).getCurrentRecipe() != null && !((TinkererMenu)this.f_97732_).getCurrentRecipe().canCraft(((TinkererMenu)this.f_97732_).container)) {
                    String component = I18n.m_118938_((String)"tooltip.valoria.required_amount", (Object[])new Object[0]);
                    PoseStack ms = pGuiGraphics.m_280168_();
                    TooltipRenderUtil.renderTooltipBackground((GuiGraphics)pGuiGraphics, (int)(pX - 110), (int)(pY - 10), (int)(Minecraft.m_91087_().f_91062_.m_92895_(component) + 20), (int)15, (int)300, (int)Color.BLACK.getRGB(), (int)Pal.darkerGray.rgb(), (int)Pal.darkishGray.rgb(), (int)Pal.lightishGray.darker().rgb());
                    ms.m_252880_((float)pX, (float)pY, 300.0f);
                    this.renderFloatingItem(pGuiGraphics, stack.m_255036_(((TinkererMenu)this.f_97732_).getCurrentRecipe().getIngredientCount()), Minecraft.m_91087_().f_91062_.m_92895_(component) - 107, k1 - 200);
                    pGuiGraphics.m_280488_(this.f_96547_, component, Minecraft.m_91087_().f_91062_.m_92895_(component) - 190, k1 - 195, Color.WHITE.getRGB());
                    ms.m_85849_();
                }
                pGuiGraphics.m_280153_(this.f_96547_, list.get(l).m_8043_(this.f_96541_.f_91073_.m_9598_()), pX, pY);
            }
        }
    }

    private void renderButtons(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int pX, int pY, int pLastVisibleElementIndex) {
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < ((TinkererMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = pX + j % 4 * 16;
            int l = j / 4;
            int i1 = pY + l * 18 + 2;
            int j1 = 166;
            if (((TinkererMenu)this.f_97732_).getCurrentRecipe() != null && !((TinkererMenu)this.f_97732_).getCurrentRecipe().canCraft(((TinkererMenu)this.f_97732_).container)) {
                pGuiGraphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
            }
            if (i == ((TinkererMenu)this.f_97732_).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (pMouseX >= k && pMouseY >= i1 && pMouseX < k + 16 && pMouseY < i1 + 18) {
                j1 += 36;
            }
            pGuiGraphics.m_280218_(this.BG_LOCATION, k, i1 - 1, 0, j1, 16, 18);
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void renderRecipes(GuiGraphics pGuiGraphics, int pX, int pY, int pStartIndex) {
        List<TinkeringRecipe> list = ((TinkererMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < pStartIndex && i < ((TinkererMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = pX + j % 4 * 16;
            int l = j / 4;
            int i1 = pY + l * 18 + 2;
            pGuiGraphics.m_280480_(list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_()), k, i1);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = pMouseX - (double)(i + i1 % 4 * 16);
                double d1 = pMouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((TinkererMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((TinkererMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (pMouseX >= (double)i && pMouseX < (double)(i + 12) && pMouseY >= (double)j && pMouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((TinkererMenu)this.f_97732_).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((TinkererMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((TinkererMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

