/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.model.entity;

import com.idark.valoria.client.model.animations.ScourgeAnimations;
import com.idark.valoria.client.model.entity.AbstractHierarchicalModel;
import com.idark.valoria.registries.entity.living.ScourgeEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ScourgeModel<T extends ScourgeEntity>
extends AbstractHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ScourgeModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.6667f, -3.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 8).m_171488_(-5.0f, -0.6667f, -4.0f, 10.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(60, 0).m_171488_(-4.0f, -4.6667f, -3.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-3.3333f, (float)-1.0f));
        PartDefinition Body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(30, 18).m_171488_(-5.0f, -6.8333f, -2.0f, 10.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(30, 34).m_171488_(-5.0f, -1.8333f, -3.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(0.1f)).m_171514_(58, 18).m_171488_(-4.0f, -6.8333f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)6.8333f, (float)0.0f));
        PartDefinition RightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-1.3333f, -4.6667f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-2.3333f, -4.6667f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(14, 24).m_171488_(-1.3333f, -4.6667f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-6.6667f, (float)4.6667f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.6667f, -4.6667f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(0, 24).m_171480_().m_171488_(-1.6667f, -4.6667f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(16, 40).m_171488_(-1.6667f, -4.6667f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)6.6667f, (float)4.6667f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171480_().m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 72).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-1.9f, (float)18.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 56).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)1.9f, (float)18.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    public ModelPart getHead() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.m_267799_(ScourgeAnimations.WALK, pLimbSwing, pLimbSwingAmount, pEntity.m_6113_(), pAgeInTicks);
        this.animateIdle(((ScourgeEntity)((Object)pEntity)).idleAnimationState, ScourgeAnimations.IDLE, pLimbSwingAmount, pAgeInTicks, 1.0f);
        this.m_233381_(((ScourgeEntity)((Object)pEntity)).attackAnimationState, ScourgeAnimations.ATTACK_MELEE, pAgeInTicks);
        this.m_233381_(((ScourgeEntity)((Object)pEntity)).diggingAnimationState, ScourgeAnimations.SPAWN, pAgeInTicks);
        this.m_233381_(((ScourgeEntity)((Object)pEntity)).deathAnimationState, ScourgeAnimations.DEATH, pAgeInTicks);
        boolean flag = pEntity.m_21256_() > 4;
        float f = 1.0f;
        if (flag) {
            f = (float)pEntity.m_20184_().m_82556_();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.3262f)) * 1.0f * pLimbSwingAmount / f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.3262f + (float)Math.PI)) * 1.0f * pLimbSwingAmount / f;
        this.rightLeg.f_104204_ = 1.5E-4f;
        this.leftLeg.f_104204_ = -1.5E-4f;
        this.rightLeg.f_104205_ = 1.5E-4f;
        this.leftLeg.f_104205_ = -1.5E-4f;
    }
}

