/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.api.unlockable;

import com.idark.valoria.Valoria;
import com.idark.valoria.api.unlockable.Unlockables;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.core.capability.IUnlockable;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.PageToastPacket;
import com.idark.valoria.core.network.packets.UnlockableUpdatePacket;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import pro.komaru.tridot.util.Tmp;

public class UnlockUtils {
    public static boolean isClaimed(Player player, Unlockable unlockable) {
        AtomicBoolean claimed = new AtomicBoolean(false);
        player.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> claimed.set(k.isClaimed(unlockable)));
        return claimed.get();
    }

    public static boolean isUnlocked(Player player, Unlockable unlockable) {
        AtomicBoolean isKnow = new AtomicBoolean(false);
        player.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> isKnow.set(k.isUnlocked(unlockable)));
        return isKnow.get();
    }

    public static Set<Unlockable> getUnlocked(Player player) {
        AtomicReference set = new AtomicReference();
        player.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> set.set(k.getUnlockables()));
        return (Set)set.get();
    }

    public static void claim(Player player, Unlockable unlockable) {
        player.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
            if (k.isClaimed(unlockable)) {
                return;
            }
            k.claim(unlockable);
        });
    }

    @Nullable
    public static Unlockable getRandom(Player player) {
        ArrayList<Unlockable> all = new ArrayList<Unlockable>(Unlockables.get());
        Set<Unlockable> unlocked = UnlockUtils.getUnlocked(player);
        if (unlocked != null) {
            all.removeAll(unlocked);
        }
        all.removeIf(unlockable -> !unlockable.canObtainByRandom());
        if (all.isEmpty()) {
            return null;
        }
        return all.get(Tmp.rnd.random(all.size() - 1));
    }

    @Nullable
    public static Unlockable getRandom() {
        ArrayList<Unlockable> list = Unlockables.get();
        return list.isEmpty() ? null : list.get(Tmp.rnd.random(list.size() - 1));
    }

    public static void addRandom(ServerPlayer entity) {
        Optional map = Unlockables.get().stream().findAny();
        if (map.isPresent()) {
            Unlockable unlockable = (Unlockable)map.get();
            entity.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
                if (k.isUnlocked(unlockable)) {
                    return;
                }
                k.addUnlockable(unlockable);
                PacketHandler.sendTo((Player)entity, (Object)new UnlockableUpdatePacket((Player)entity));
                PacketHandler.sendTo((Player)entity, (Object)new PageToastPacket((Player)entity, unlockable.icon, true));
            });
        }
    }

    public static void add(ServerPlayer entity, Unlockable unlockable) {
        entity.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
            if (k.isUnlocked(unlockable)) {
                return;
            }
            k.addUnlockable(unlockable);
            PacketHandler.sendTo((Player)entity, (Object)new UnlockableUpdatePacket((Player)entity));
            PacketHandler.sendTo((Player)entity, (Object)new PageToastPacket((Player)entity, unlockable.icon, true));
        });
        Valoria.LOGGER.debug("{} unlocked page {}", (Object)entity.m_5446_().getString(), (Object)unlockable.id);
    }

    public static void remove(ServerPlayer entity, Unlockable unlockable) {
        entity.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
            if (!k.isUnlocked(unlockable)) {
                return;
            }
            k.removeUnlockable(unlockable);
            PacketHandler.sendTo((Player)entity, (Object)new UnlockableUpdatePacket((Player)entity));
            PacketHandler.sendTo((Player)entity, (Object)new PageToastPacket((Player)entity, unlockable.icon, false));
        });
    }

    public static void addAll(ServerPlayer entity) {
        entity.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
            k.addAllUnlockable();
            PacketHandler.sendTo((Player)entity, (Object)new UnlockableUpdatePacket((Player)entity));
        });
    }

    public static void removeAll(ServerPlayer entity) {
        entity.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
            k.removeAllUnlockable();
            k.clearClaimed();
            PacketHandler.sendTo((Player)entity, (Object)new UnlockableUpdatePacket((Player)entity));
        });
    }
}

