/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria;

import com.idark.valoria.Valoria;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.level.LevelGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StructureEvents {
    @SubscribeEvent
    public void onTeleportTry(EntityTeleportEvent.EnderPearl e) {
        ServerLevel level;
        BlockPos pos = BlockPos.m_274446_((Position)e.getTarget());
        Level level2 = e.getEntity().m_9236_();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).m_46472_() == LevelGen.VALORIA_KEY && level.m_46469_().m_46207_(Valoria.DISABLE_BLOCK_BREAKING) && this.isInStructure(pos, level)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDestroyTry(BlockEvent.BreakEvent e) {
        ServerLevel level;
        BlockPos pos = e.getPos();
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_46472_() == LevelGen.VALORIA_KEY && level.m_46469_().m_46207_(Valoria.DISABLE_BLOCK_BREAKING) && !level.m_8055_(pos).m_204336_(TagsRegistry.ALLOWED_TO_BREAK) && this.isInStructure(pos, level)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start e) {
        ServerLevel level;
        BlockPos pos = BlockPos.m_274446_((Position)e.getExplosion().getPosition());
        Level level2 = e.getLevel();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).m_46472_() == LevelGen.VALORIA_KEY && level.m_46469_().m_46207_(Valoria.DISABLE_BLOCK_BREAKING) && !level.m_8055_(pos).m_204336_(TagsRegistry.ALLOWED_TO_BREAK) && this.isInStructure(pos, level)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFluidPlace(BlockEvent.FluidPlaceBlockEvent e) {
        ServerLevel level;
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_46472_() == LevelGen.VALORIA_KEY && level.m_46469_().m_46207_(Valoria.DISABLE_BLOCK_BREAKING) && this.isInStructure(e.getPos(), level)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent e) {
        ServerLevel level;
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_46472_() == LevelGen.VALORIA_KEY && level.m_46469_().m_46207_(Valoria.DISABLE_BLOCK_BREAKING) && this.isInStructure(e.getPos(), level)) {
            e.setCanceled(true);
        }
    }

    public boolean isInStructure(BlockPos pos, ServerLevel serverLevel) {
        StructureStart structure = serverLevel.m_215010_().m_220488_(pos, LevelGen.VALORIA_FORTRESS);
        return !structure.m_73602_().isEmpty() && structure.m_73601_().m_71051_((Vec3i)pos);
    }
}

