/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria;

import com.idark.valoria.Valoria;
import com.idark.valoria.api.unlockable.Unlockables;
import com.idark.valoria.api.unlockable.types.ItemUnlockable;
import com.idark.valoria.client.ui.screen.book.BookGui;
import com.idark.valoria.client.ui.screen.book.codex.ChapterNode;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntries;
import com.idark.valoria.core.DamageData;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.core.interfaces.ILivingEntityData;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.entity.living.decoration.MannequinEntity;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.ValoriaUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forgespi.language.IModInfo;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;

public class ClientEvents {
    public static final DecimalFormat FORMAT = new DecimalFormat("###.##", new DecimalFormatSymbols(Locale.ENGLISH));

    @SubscribeEvent
    public static void onEntityRender(RenderLivingEvent.Post<LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        ILivingEntityData data = (ILivingEntityData)entity;
        float lastDamage = data.valoria$getLastDamage();
        if ((((Boolean)ClientConfig.DAMAGE_INDICATOR.get()).booleanValue() || entity instanceof MannequinEntity) && lastDamage > 0.0f && entity.f_20916_ > 0) {
            MutableComponent component = Component.m_237113_((String)FORMAT.format(lastDamage));
            Col textColor = Col.red;
            for (DamageData damageData : DamageData.dataTypes) {
                if (data.valoria$getLastDamageSource() == null || !damageData.predicate().test(data.valoria$getLastDamageSource())) continue;
                if (damageData.getText() != null) {
                    component = damageData.getText();
                }
                textColor = damageData.getColor();
            }
            ValoriaUtils.renderText(entity, textColor, (Component)component, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), entity.f_20916_);
        }
        if (data.valoria$getMissTime() > 0) {
            ValoriaUtils.renderText(entity, Col.lightGray, (Component)Component.m_237113_((String)"Miss..."), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), data.valoria$getMissTime());
        }
        if (data.valoria$getDodgeTime() > 0) {
            ValoriaUtils.renderText(entity, Col.lightGray, (Component)Component.m_237113_((String)"Dodge!"), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), data.valoria$getDodgeTime());
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = event.getScreen();
        if (screen instanceof EffectRenderingInventoryScreen) {
            EffectRenderingInventoryScreen inventoryScreen = (EffectRenderingInventoryScreen)screen;
            if (event.getButton() == 1) {
                if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341)) {
                    return;
                }
                Slot hovered = inventoryScreen.getSlotUnderMouse();
                if (hovered == null) {
                    return;
                }
                Optional<ItemUnlockable> unlockable = Unlockables.getUnlockableByItem(hovered.m_7993_().m_41720_());
                if (unlockable.isPresent()) {
                    ChapterNode node = CodexEntries.getNode(unlockable.get());
                    mc.f_91074_.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (node == null) {
                        return;
                    }
                    mc.m_91152_((Screen)new BookGui(node.chapter, true));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTooltipRender(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getItemStack();
        if (Unlockables.getUnlockableByItem(stack.m_41720_()).isPresent()) {
            GuiGraphics gfx = event.getGraphics();
            PoseStack pose = gfx.m_280168_();
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 500.0f);
            int n = event.getComponents().size();
            Objects.requireNonNull(event.getFont());
            int tooltipHeight = n * 9;
            int iconX = event.getX();
            int iconY = event.getY() + tooltipHeight - 18;
            gfx.m_280480_(((Item)ItemsRegistry.codex.get()).m_7968_(), iconX, iconY);
            pose.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onClientJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        IModInfo modInfo = (IModInfo)ModList.get().getModFileById("valoria").getMods().get(0);
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)modInfo);
        if (((Boolean)ClientConfig.SHOW_UPDATES.get()).booleanValue() && result.status().shouldDraw()) {
            String newVersion = result.target().toString();
            MutableComponent message = Component.m_237113_((String)"\ud83e\udeb7 Valoria: ").m_130938_(style -> DotStyle.of().color(Pal.verySoftPink)).m_7220_((Component)Component.m_237110_((String)"tooltip.valoria.update_available", (Object[])new Object[]{newVersion}).m_130940_(ChatFormatting.WHITE));
            MutableComponent actions = Component.m_237115_((String)"tooltip.valoria.download").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131150_(Valoria.FONT).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/valoria"))).m_7220_((Component)Component.m_237113_((String)" | ").m_7220_((Component)Component.m_237115_((String)"tooltip.valoria.hide").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131150_(Valoria.FONT).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, new File(ConfigTracker.INSTANCE.getConfigFileName("valoria", ModConfig.Type.CLIENT)).getAbsolutePath())))).m_7220_((Component)Component.m_237113_((String)" | ")).m_7220_((Component)Component.m_237115_((String)"tooltip.valoria.patreon").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/c/valoriamod")))));
            MutableComponent separator = Component.m_237113_((String)"<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->").m_130938_(style -> DotStyle.of().color(Pal.verySoftPink.copy().darker()));
            event.getPlayer().m_5661_((Component)separator, false);
            event.getPlayer().m_5661_((Component)message, false);
            event.getPlayer().m_5661_((Component)Component.m_237119_(), false);
            event.getPlayer().m_5661_((Component)actions, false);
            event.getPlayer().m_5661_((Component)separator, false);
        }
    }
}

