/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.client.screen;

import com.google.common.collect.Sets;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.origins.api.origin.IOriginCallbackPower;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.C2SFinalizeNowReadyPowers;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class WaitForPowersScreen
extends OriginDisplayScreen {
    private static final ResourceLocation WAITING_WINDOW = new ResourceLocation("origins", "textures/gui/wait_for_powers.png");
    private final Set<ResourceKey<ConfiguredPower<?, ?>>> waitingFor = Sets.newHashSet();
    private final boolean wasOrb;

    public WaitForPowersScreen(boolean showDirtBackground, Set<ResourceKey<ConfiguredPower<?, ?>>> waitingFor, boolean wasOrb) {
        super((Component)Component.m_237119_(), showDirtBackground);
        this.waitingFor.addAll(waitingFor);
        this.wasOrb = wasOrb;
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.time += delta;
        this.m_280273_(graphics);
        graphics.m_280218_(WAITING_WINDOW, this.guiLeft, this.guiTop, 0, 0, 176, 182);
        this.renderWaitingText(graphics);
    }

    public void m_86600_() {
        if (this.areAllPowersReadyToGo()) {
            OriginsCommon.CHANNEL.sendToServer((Object)new C2SFinalizeNowReadyPowers(this.waitingFor, this.wasOrb));
            this.m_7379_();
        }
    }

    private boolean areAllPowersReadyToGo() {
        return this.waitingFor.stream().map(key -> (ConfiguredPower)ApoliAPI.getPowers().m_6246_(key)).allMatch(p -> {
            IOriginCallbackPower callbackPower;
            PowerFactory patt2429$temp;
            return p == null || !((patt2429$temp = p.getFactory()) instanceof IOriginCallbackPower) || (callbackPower = (IOriginCallbackPower)patt2429$temp).isReady(p, (Entity)this.f_96541_.f_91074_, this.wasOrb);
        });
    }

    private void renderWaitingText(@NotNull GuiGraphics graphics) {
        int textWidth = 128;
        int dotAmount = (int)(this.time / 10.0f % 4.0f);
        MutableComponent component = Component.m_237115_((String)"origins.gui.waiting_for_powers");
        for (int i = 0; i < dotAmount; ++i) {
            component.m_130946_(".");
        }
        List components = this.f_96547_.m_92923_((FormattedText)component, textWidth);
        int x = this.guiLeft + 88;
        int y = this.guiTop + 50;
        for (FormattedCharSequence c : components) {
            graphics.m_280364_(this.f_96547_, c, x, y, 0xFFFFFF);
            y += 12;
        }
    }

    public boolean m_6913_() {
        return false;
    }
}

