/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.command.LayerArgumentType;
import io.github.apace100.origins.command.OriginArgumentType;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsBuiltinRegistries;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2COpenOriginScreen;
import io.github.edwinmindcraft.origins.common.registry.OriginRegisters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class OriginCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"origin").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(Commands.m_82129_((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(OriginCommand::setOrigin)))))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(Commands.m_82129_((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(OriginCommand::hasOrigin)))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::getOrigin))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"gui").executes(command -> OriginCommand.openMultipleLayerScreens((CommandContext<CommandSourceStack>)command, TargetType.INVOKER))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(command -> OriginCommand.openMultipleLayerScreens((CommandContext<CommandSourceStack>)command, TargetType.SPECIFY))).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::openSingleLayerScreen))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"random").executes(command -> OriginCommand.randomizeOrigins((CommandContext<CommandSourceStack>)command, TargetType.INVOKER))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(command -> OriginCommand.randomizeOrigins((CommandContext<CommandSourceStack>)command, TargetType.SPECIFY))).then(Commands.m_82129_((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(OriginCommand::randomizeOrigin)))));
    }

    private static int setOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        ResourceKey<OriginLayer> originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        ResourceKey<Origin> origin = OriginArgumentType.getOrigin(commandContext, "origin");
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        int processedTargets = 0;
        Optional layerHolder = OriginsAPI.getLayersRegistry().m_203636_(originLayer);
        Optional originHolder = OriginsAPI.getOriginsRegistry().m_203636_(origin);
        if (layerHolder.isPresent() && ((Holder.Reference)layerHolder.get()).m_203633_() && originHolder.isPresent() && ((Holder.Reference)originHolder.get()).m_203633_() && (origin.equals((Object)OriginRegisters.EMPTY.getKey()) || ((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).contains(origin.m_135782_()))) {
            for (ServerPlayer target : targets) {
                OriginCommand.setOrigin((Player)target, originLayer, origin);
                ++processedTargets;
            }
            if (processedTargets == 1) {
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.set.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_().getString(), ((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).name(), ((Origin)((Holder.Reference)originHolder.get()).m_203334_()).getName()}), true);
            } else {
                int finalProcessedTargets = processedTargets;
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.set.success.multiple", (Object[])new Object[]{finalProcessedTargets, ((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).name(), ((Origin)((Holder.Reference)originHolder.get()).m_203334_()).getName()}), true);
            }
        } else {
            serverCommandSource.m_81352_((Component)Component.m_237110_((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.m_135782_(), originLayer.m_135782_()}));
        }
        return processedTargets;
    }

    private static void setOrigin(Player player, ResourceKey<OriginLayer> layer, ResourceKey<Origin> origin) {
        IOriginContainer.get((Entity)player).ifPresent(container -> {
            container.setOrigin(layer, origin);
            container.synchronize();
            container.onChosen(origin, container.hadAllOrigins());
        });
    }

    private static int hasOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        ResourceKey<OriginLayer> originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        ResourceKey<Origin> origin = OriginArgumentType.getOrigin(commandContext, "origin");
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        Optional layerHolder = OriginsAPI.getLayersRegistry().m_203636_(originLayer);
        Optional originHolder = OriginsAPI.getOriginsRegistry().m_203636_(origin);
        int processedTargets = 0;
        if (layerHolder.isPresent() && ((Holder.Reference)layerHolder.get()).m_203633_() && originHolder.isPresent() && ((Holder.Reference)originHolder.get()).m_203633_() && (origin.equals((Object)OriginRegisters.EMPTY.getKey()) || ((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).contains(origin))) {
            for (ServerPlayer target : targets) {
                LazyOptional<IOriginContainer> originContainer = IOriginContainer.get((Entity)target);
                if (!originContainer.resolve().isPresent() || !origin.equals(OriginsBuiltinRegistries.ORIGINS.get().getResourceKey((Object)Origin.EMPTY).get()) && !((IOriginContainer)originContainer.resolve().get()).hasOrigin(originLayer) || !OriginCommand.hasOrigin((Player)target, originLayer, origin)) continue;
                ++processedTargets;
            }
            if (processedTargets == 0) {
                serverCommandSource.m_81352_((Component)Component.m_237115_((String)"commands.execute.conditional.fail"));
            } else if (processedTargets == 1) {
                serverCommandSource.m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.pass"), true);
            } else {
                int finalProcessedTargets = processedTargets;
                serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.execute.conditional.pass_count", (Object[])new Object[]{finalProcessedTargets}), true);
            }
        } else {
            serverCommandSource.m_81352_((Component)Component.m_237110_((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.m_135782_(), originLayer.m_135782_()}));
        }
        return processedTargets;
    }

    private static boolean hasOrigin(Player player, ResourceKey<OriginLayer> layer, ResourceKey<Origin> origin) {
        return IOriginContainer.get((Entity)player).map(x -> Objects.equals(x.getOrigin(layer), origin)).orElse(false);
    }

    private static int getOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(commandContext, (String)"target");
        ResourceKey<OriginLayer> originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        Optional layerHolder = OriginsAPI.getLayersRegistry().m_203636_(originLayer);
        IOriginContainer.get((Entity)target).ifPresent(container -> {
            ResourceKey<Origin> origin = container.getOrigin(originLayer);
            Optional originHolder = OriginsAPI.getOriginsRegistry().m_203636_(origin);
            serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.get.result", (Object[])new Object[]{target.m_5446_().getString(), ((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).name(), ((Origin)((Holder.Reference)originHolder.get()).m_203334_()).getName(), origin.m_135782_()}), true);
        });
        return 1;
    }

    private static int openSingleLayerScreen(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        ResourceKey<OriginLayer> originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        OriginsAPI.getLayersRegistry().m_203636_(originLayer).ifPresent(holder -> {
            for (ServerPlayer target : targets) {
                OriginCommand.openLayerScreen(target, List.of(holder));
            }
            serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.gui.layer", (Object[])new Object[]{targets.size(), ((OriginLayer)holder.m_203334_()).name()}), true);
        });
        return targets.size();
    }

    private static int openMultipleLayerScreens(CommandContext<CommandSourceStack> commandContext, TargetType targetType) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        ArrayList<ServerPlayer> targets = new ArrayList<ServerPlayer>();
        List<Holder<OriginLayer>> originLayers = OriginsAPI.getActiveLayers().stream().map(reference -> reference).toList();
        switch (targetType) {
            case INVOKER: {
                targets.add(serverCommandSource.m_81375_());
                break;
            }
            case SPECIFY: {
                targets.addAll(EntityArgument.m_91477_(commandContext, (String)"targets"));
            }
        }
        for (ServerPlayer target : targets) {
            OriginCommand.openLayerScreen(target, originLayers);
        }
        serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.gui.all", (Object[])new Object[]{targets.size()}), false);
        return targets.size();
    }

    private static int randomizeOrigin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        Collection targets = EntityArgument.m_91477_(commandContext, (String)"targets");
        ResourceKey<OriginLayer> originLayer = LayerArgumentType.getLayer(commandContext, "layer");
        Optional layerHolder = OriginsAPI.getLayersRegistry().m_203636_(originLayer);
        if (layerHolder.isPresent() && ((Holder.Reference)layerHolder.get()).m_203633_()) {
            if (((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).allowRandom()) {
                Holder<Origin> origin = null;
                for (ServerPlayer target : targets) {
                    origin = OriginCommand.getRandomOrigin(target, (Holder<OriginLayer>)((Holder)layerHolder.get()));
                }
                if (targets.size() > 1) {
                    serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.random.success.multiple", (Object[])new Object[]{targets.size(), ((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).name()}), true);
                } else if (targets.size() == 1) {
                    Holder<Origin> finalOrigin = origin;
                    serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.random.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_().getString(), ((Origin)finalOrigin.m_203334_()).getName(), ((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).name()}), false);
                }
                return targets.size();
            }
            serverCommandSource.m_81352_((Component)Component.m_237110_((String)"commands.origin.random.not_allowed", (Object[])new Object[]{((OriginLayer)((Holder.Reference)layerHolder.get()).m_203334_()).name()}));
            return 0;
        }
        return 0;
    }

    private static int randomizeOrigins(CommandContext<CommandSourceStack> commandContext, TargetType targetType) throws CommandSyntaxException {
        CommandSourceStack serverCommandSource = (CommandSourceStack)commandContext.getSource();
        ArrayList<ServerPlayer> targets = new ArrayList<ServerPlayer>();
        List<Holder.Reference> originLayers = OriginsAPI.getActiveLayers().stream().filter(originLayerReference -> originLayerReference.m_203633_() && ((OriginLayer)originLayerReference.m_203334_()).allowRandom()).toList();
        switch (targetType) {
            case INVOKER: {
                targets.add(serverCommandSource.m_81375_());
                break;
            }
            case SPECIFY: {
                targets.addAll(EntityArgument.m_91477_(commandContext, (String)"targets"));
            }
        }
        for (ServerPlayer target : targets) {
            for (Holder.Reference originLayer : originLayers) {
                OriginCommand.getRandomOrigin(target, (Holder<OriginLayer>)originLayer);
            }
        }
        serverCommandSource.m_288197_(() -> Component.m_237110_((String)"commands.origin.random.all", (Object[])new Object[]{targets.size(), originLayers.size()}), false);
        return targets.size();
    }

    private static void openLayerScreen(ServerPlayer target, List<Holder<OriginLayer>> originLayers) {
        LazyOptional<IOriginContainer> originContainer = IOriginContainer.get((Entity)target);
        originContainer.ifPresent(container -> {
            for (Holder layer : originLayers) {
                container.setOrigin((ResourceKey<OriginLayer>)((ResourceKey)layer.m_203543_().orElseThrow()), (ResourceKey<Origin>)OriginRegisters.EMPTY.getKey());
            }
            container.synchronize();
            container.checkAutoChoosingLayers(false);
            OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new S2COpenOriginScreen(false));
        });
    }

    private static Holder<Origin> getRandomOrigin(ServerPlayer target, Holder<OriginLayer> originLayer) {
        List<Holder<Origin>> origins = ((OriginLayer)originLayer.m_203334_()).randomOrigins((Player)target);
        Holder<Origin> origin = origins.get(new Random().nextInt(origins.size()));
        LazyOptional<IOriginContainer> originContainer = IOriginContainer.get((Entity)target);
        originContainer.ifPresent(container -> {
            boolean hadOriginBefore = container.hadAllOrigins();
            boolean hadAllOrigins = container.hasAllOrigins();
            container.setOrigin(originLayer, origin);
            container.checkAutoChoosingLayers(false);
            container.synchronize();
            if (container.hasAllOrigins() && !hadAllOrigins) {
                container.onChosen(hadOriginBefore);
            }
            if (origin.m_203543_().isEmpty() || originLayer.m_203543_().isEmpty()) {
                return;
            }
            Origins.LOGGER.info("Player {} was randomly assigned the origin {} for layer {}", (Object)target.m_5446_().getString(), (Object)((ResourceKey)origin.m_203543_().get()).m_135782_(), (Object)((ResourceKey)originLayer.m_203543_().get()).m_135782_());
        });
        return origin;
    }

    private static enum TargetType {
        INVOKER,
        SPECIFY;

    }
}

