/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.network;

import com.ldtteam.domumornamentum.network.messages.CreativeSetArchitectCutterSlotMessage;
import com.ldtteam.domumornamentum.network.messages.IMessage;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public class NetworkChannel {
    private final SimpleChannel rawChannel;

    public NetworkChannel(String channelName) {
        String modVersion = ((ModContainer)ModList.get().getModContainerById("domum_ornamentum").get()).getModInfo().getVersion().toString();
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("domum_ornamentum", channelName), () -> modVersion, str -> str.equals(modVersion), str -> str.equals(modVersion));
    }

    public void registerMessages() {
        int idx = 0;
        this.registerMessage(++idx, CreativeSetArchitectCutterSlotMessage.class, CreativeSetArchitectCutterSlotMessage::new);
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz, Function<FriendlyByteBuf, MSG> msgCreator) {
        this.rawChannel.registerMessage(id, msgClazz, IMessage::toBytes, msgCreator, NetworkChannel::execute);
    }

    private static void execute(@NotNull IMessage msg, @NotNull Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
        if (msg.getExecutionSide() == null || !packetOrigin.equals((Object)msg.getExecutionSide())) {
            ctx.enqueueWork(() -> msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        }
    }

    public void sendToServer(IMessage msg) {
        this.rawChannel.sendToServer((Object)msg);
    }

    public void sendToPlayer(IMessage msg, ServerPlayer player) {
        this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }
}

