/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.post;

import com.ldtteam.domumornamentum.block.AbstractPostBlock;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PostBlock;
import com.ldtteam.domumornamentum.block.types.PostType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PostBlockStateProvider
extends BlockStateProvider {
    public PostBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)ModBlocks.getInstance().getPost());
        for (Direction facingValue : AbstractPostBlock.f_52588_.m_6908_()) {
            for (Boolean upright : AbstractPostBlock.UPRIGHT.m_6908_()) {
                for (PostType typeValue : PostBlock.TYPE.m_6908_()) {
                    ConfiguredModel.Builder partBuilder = builder.part();
                    ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/post/post_" + typeValue.m_7912_(), this.modLoc("block/post/post_%s_spec".formatted(typeValue.m_7912_())))).customLoader(MateriallyTexturedModelBuilder::new)).end()).rotationY(this.getYFromFacing(facingValue)).rotationX(this.getXFromFacing(facingValue) + this.getUpright(upright, facingValue)).addModel()).condition((Property)AbstractPostBlock.UPRIGHT, (Comparable[])new Boolean[]{upright}).condition((Property)AbstractPostBlock.f_52588_, (Comparable[])new Direction[]{facingValue}).condition((Property)PostBlock.TYPE, (Comparable[])new PostType[]{typeValue}).end();
                }
            }
        }
        ItemModelBuilder itemSpecModelBuilder = (ItemModelBuilder)this.itemModels().withExistingParent("post_spec", this.mcLoc("block/thin_block"));
        PostType[] values = PostType.values();
        for (int i = 0; i < values.length; ++i) {
            PostType value = values[i];
            ItemModelBuilder.OverrideBuilder overrideBuilder = itemSpecModelBuilder.override();
            overrideBuilder.predicate(new ResourceLocation("domum_ornamentum:post_type"), (float)i);
            overrideBuilder.model((ModelFile)this.itemModels().getExistingFile(this.modLoc("block/post/post_%s_spec".formatted(value.m_7912_()))));
            overrideBuilder.end();
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getPost().getRegistryName().m_135815_())).parent((ModelFile)itemSpecModelBuilder)).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @Contract(pure=true)
    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getXFromFacing(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> 180;
            case Direction.DOWN -> 0;
            case Direction.NORTH -> 0;
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 0;
            case Direction.EAST -> 0;
        };
    }

    private int getUpright(Boolean upright, Direction direction) {
        if (!upright.booleanValue() && direction != Direction.DOWN && direction != Direction.UP) {
            return 90;
        }
        return 0;
    }

    @NotNull
    public String m_6055_() {
        return "Post BlockStates Provider";
    }
}

