/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.fencegate;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.vanilla.FenceGateBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class FenceGateBlockStateProvider
extends BlockStateProvider {
    public FenceGateBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        Iterator iterator;
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)ModBlocks.getInstance().getFenceGate());
        record FenceGateModelData(boolean wallState, boolean open) {
        }
        HashMap<FenceGateModelData, ModelFile> models = new HashMap<FenceGateModelData, ModelFile>();
        Iterator iterator2 = FenceGateBlock.f_53343_.m_6908_().iterator();
        while (iterator2.hasNext()) {
            boolean wallState = (Boolean)iterator2.next();
            iterator = FenceGateBlock.f_53341_.m_6908_().iterator();
            while (iterator.hasNext()) {
                boolean open = (Boolean)iterator.next();
                models.put(new FenceGateModelData(wallState, open), this.generateBlockModel(wallState, open));
            }
        }
        for (Direction direction : HorizontalDirectionalBlock.f_54117_.m_6908_()) {
            iterator = FenceGateBlock.f_53343_.m_6908_().iterator();
            while (iterator.hasNext()) {
                boolean wallState = (Boolean)iterator.next();
                Iterator iterator3 = FenceGateBlock.f_53341_.m_6908_().iterator();
                while (iterator3.hasNext()) {
                    boolean open = (Boolean)iterator3.next();
                    ModelFile blockModel = (ModelFile)models.get(new FenceGateModelData(wallState, open));
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(blockModel).rotationY(this.getYFromFacing(direction)).addModel()).condition((Property)HorizontalDirectionalBlock.f_54117_, (Comparable[])new Direction[]{direction}).condition((Property)FenceGateBlock.f_53343_, (Comparable[])new Boolean[]{wallState}).condition((Property)FenceGateBlock.f_53341_, (Comparable[])new Boolean[]{open});
                }
            }
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(ModBlocks.getInstance().getFenceGate().getRegistryName().m_135815_(), this.modLoc("item/fence_gate/fence_gate_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    private ModelFile generateBlockModel(boolean wallState, boolean open) {
        String name = "block/fence_gate/fence_gate_" + (wallState ? "wall_" : "") + (open ? "open" : "");
        ResourceLocation specLocation = new ResourceLocation("domum_ornamentum", "block/fence_gate/fence_gate_" + (wallState ? "wall_" : "") + (open ? "open_" : "") + "spec");
        return ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, specLocation)).customLoader(MateriallyTexturedModelBuilder::new)).end();
    }

    @NotNull
    public String m_6055_() {
        return "FenceGate BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
        };
    }
}

