/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.AbstractBlock;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.DynamicTimberFrameBlockEntity;
import com.ldtteam.domumornamentum.recipe.FinishedDORecipe;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicTimberFrameBlock
extends AbstractBlock<DynamicTimberFrameBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/oak_planks"), ModTags.TIMBERFRAMES_FRAME, Blocks.f_50705_)).add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/dark_oak_planks"), ModTags.TIMBERFRAMES_CENTER, Blocks.f_50745_)).build();
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public DynamicTimberFrameBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278166_(PushReaction.PUSH_ONLY).m_60913_(3.0f, 1.0f).m_60955_());
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity timberFrameBlockEntity = (DynamicTimberFrameBlockEntity)tileEntity;
            MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(stack.m_41698_("textureData"));
            if (textureData.isEmpty()) {
                textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(this);
            }
            timberFrameBlockEntity.updateTextureDataWith(textureData);
            timberFrameBlockEntity.refreshTextureCache();
            for (Offset offset : Offset.values()) {
                DynamicTimberFrameBlock.updateNeighbor(timberFrameBlockEntity, worldIn.m_7702_(offset.applyToBlockPos(pos)), offset, true);
            }
        }
    }

    private static void updateNeighbor(DynamicTimberFrameBlockEntity thisEntity, BlockEntity neighborEntity, Offset offset, boolean added) {
        if (neighborEntity != null && neighborEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity timberFrameBlockEntity = (DynamicTimberFrameBlockEntity)neighborEntity;
            timberFrameBlockEntity.onNeighborUpdate(thisEntity, offset.inverted(), added);
            if (thisEntity != null && timberFrameBlockEntity.getFrameBlock() == thisEntity.getFrameBlock() && timberFrameBlockEntity.getCenterBlock() == thisEntity.getCenterBlock()) {
                thisEntity.onNeighborUpdate(thisEntity, offset, added);
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, @NotNull Direction direction, @NotNull BlockState directionState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos directionPos) {
        BlockEntity tileEntity = worldIn.m_7702_(currentPos);
        if (tileEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity timberFrameBlockEntity = (DynamicTimberFrameBlockEntity)tileEntity;
            for (Offset offset : Offset.values()) {
                DynamicTimberFrameBlock.updateNeighbor(timberFrameBlockEntity, worldIn.m_7702_(offset.applyToBlockPos(currentPos)), offset, true);
            }
        }
        return stateIn;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState otherState, boolean drop) {
        super.m_6810_(state, worldIn, pos, otherState, drop);
        for (Offset offset : Offset.values()) {
            DynamicTimberFrameBlock.updateNeighbor(null, worldIn.m_7702_(offset.applyToBlockPos(pos)), offset, false);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new DynamicTimberFrameBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos);
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    @Override
    @NotNull
    public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedDORecipe(){

            public void m_7917_(@NotNull JsonObject json) {
                json.addProperty("count", (Number)COMPONENTS.size());
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(DynamicTimberFrameBlock.this.getRegistryName(DynamicTimberFrameBlock.this.getBlock()));
            }
        }});
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.m_5880_(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(1);
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        this.fillDOItemCategory(this, items, this.fillItemGroupCache);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity dynamicTimberFrameBlockEntity = (DynamicTimberFrameBlockEntity)blockEntity;
            dynamicTimberFrameBlockEntity.rotate(direction.ordinal());
        }
        return super.rotate(state, level, pos, direction);
    }

    public BlockState m_6843_(BlockState p_60530_, Rotation p_60531_) {
        return super.m_6843_(p_60530_, p_60531_);
    }

    public static enum Offset {
        UP(BlockPos::m_7494_),
        DOWN(BlockPos::m_7495_),
        NORTH(BlockPos::m_122012_),
        EAST(BlockPos::m_122029_),
        SOUTH(BlockPos::m_122019_),
        WEST(BlockPos::m_122024_),
        UP_EAST(p -> p.m_7494_().m_122029_()),
        UP_WEST(p -> p.m_7494_().m_122024_()),
        UP_NORTH(p -> p.m_7494_().m_122012_()),
        UP_SOUTH(p -> p.m_7494_().m_122019_()),
        DOWN_EAST(p -> p.m_7495_().m_122029_()),
        DOWN_WEST(p -> p.m_7495_().m_122024_()),
        DOWN_NORTH(p -> p.m_7495_().m_122012_()),
        DOWN_SOUTH(p -> p.m_7495_().m_122019_());

        private final Function<BlockPos, BlockPos> posTranslationFunction;

        private Offset(Function<BlockPos, BlockPos> changeFunction) {
            this.posTranslationFunction = changeFunction;
        }

        public Offset inverted() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case UP -> DOWN;
                case DOWN -> UP;
                case NORTH -> SOUTH;
                case SOUTH -> NORTH;
                case EAST -> WEST;
                case WEST -> EAST;
                case UP_NORTH -> DOWN_SOUTH;
                case UP_EAST -> DOWN_WEST;
                case UP_SOUTH -> DOWN_NORTH;
                case UP_WEST -> DOWN_EAST;
                case DOWN_SOUTH -> UP_NORTH;
                case DOWN_WEST -> UP_EAST;
                case DOWN_NORTH -> UP_SOUTH;
                case DOWN_EAST -> UP_WEST;
            };
        }

        public BlockPos applyToBlockPos(BlockPos pos) {
            return this.posTranslationFunction.apply(pos);
        }

        public Offset rotate() {
            return switch (this) {
                case NORTH -> EAST;
                case SOUTH -> WEST;
                case EAST -> SOUTH;
                case WEST -> NORTH;
                case UP_NORTH -> UP_EAST;
                case UP_EAST -> UP_SOUTH;
                case UP_SOUTH -> UP_WEST;
                case UP_WEST -> UP_NORTH;
                case DOWN_SOUTH -> DOWN_WEST;
                case DOWN_WEST -> DOWN_NORTH;
                case DOWN_NORTH -> DOWN_EAST;
                case DOWN_EAST -> DOWN_SOUTH;
                default -> this;
            };
        }
    }
}

