/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.affix.IAffixBase;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.Utils;
import top.theillusivec4.champions.server.command.AffixArgumentType;

public class ChampionsCommand {
    public static final SuggestionProvider<CommandSourceStack> AFFIXES = SuggestionProviders.m_121658_((ResourceLocation)Utils.getLocation("affixes"), (context, builder) -> SharedSuggestionProvider.m_82960_(AffixRegistry.getRegistry().getValues().stream().filter(IAffixBase::isEnabled), (SuggestionsBuilder)builder, IAffixBase::getIdentifier, affix -> Component.m_237115_((String)affix.toLanguageKey())));
    public static final SuggestionProvider<CommandSourceStack> MONSTER_ENTITIES = SuggestionProviders.m_121658_((ResourceLocation)Utils.getLocation("monster_entities"), (context, builder) -> SharedSuggestionProvider.m_82960_(ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(ChampionHelper::isValidChampionEntityType), (SuggestionsBuilder)builder, EntityType::m_20613_, type -> Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)EntityType.m_20613_((EntityType)type)))));
    private static final DynamicCommandExceptionType UNKNOWN_ENTITY = new DynamicCommandExceptionType(type -> Component.m_237110_((String)"command.champions.egg.unknown_entity", (Object[])new Object[]{type}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder championsCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"champions").requires(player -> player.m_6761_(opPermissionLevel));
        championsCommand.then(Commands.m_82127_((String)"egg").then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ChampionsCommand.createEgg((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.m_82129_((String)"affixes", (ArgumentType)AffixArgumentType.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.createEgg((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgumentType.getAffixes((CommandContext<CommandSourceStack>)context, "affixes")))))));
        championsCommand.then(Commands.m_82127_((String)"summon").then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.m_82129_((String)"affixes", (ArgumentType)AffixArgumentType.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgumentType.getAffixes((CommandContext<CommandSourceStack>)context, "affixes")))))));
        championsCommand.then(Commands.m_82127_((String)"summonpos").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), BlockPosArgument.m_174395_((CommandContext)context, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.m_82129_((String)"affixes", (ArgumentType)AffixArgumentType.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), BlockPosArgument.m_174395_((CommandContext)context, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgumentType.getAffixes((CommandContext<CommandSourceStack>)context, "affixes"))))))));
        dispatcher.register(championsCommand);
    }

    private static int summon(CommandSourceStack source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        return ChampionsCommand.summon(source, null, resourceLocation, tier, affixes);
    }

    private static int summon(CommandSourceStack source, @Nullable BlockPos pos, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        Entity entity;
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
        if (entityType == null) {
            throw UNKNOWN_ENTITY.create((Object)resourceLocation);
        }
        Entity sourceEntity = source.m_81373_();
        if (sourceEntity != null && (entity = entityType.m_262451_((ServerLevel)sourceEntity.m_9236_(), null, null, pos != null ? pos : new BlockPos((Vec3i)sourceEntity.m_20183_()), MobSpawnType.COMMAND, false, false)) instanceof LivingEntity) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> ChampionBuilder.spawnPreset(champion, tier, new ArrayList<IAffix>(affixes)));
            source.m_81372_().m_7967_(entity);
            source.m_288197_(() -> Component.m_237110_((String)"commands.champions.summon.success", (Object[])new Object[]{Component.m_237115_((String)("rank.champions.title." + tier)).getString() + " " + entity.m_5446_().getString()}), false);
        }
        return 1;
    }

    private static int createEgg(CommandSourceStack source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        EntityType<?> entityType = ChampionsCommand.getTypeOrThrow(resourceLocation);
        ServerPlayer player = source.m_81375_();
        ItemStack egg = ChampionsCommand.createEgg(entityType, tier, affixes);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)egg, (int)1);
        source.m_288197_(() -> Component.m_237110_((String)"commands.champions.egg.success", (Object[])new Object[]{egg.m_41611_()}), false);
        return 1;
    }

    public static ItemStack createEgg(EntityType<?> entityType, int tier, Collection<IAffix> affixes) {
        ItemStack egg = new ItemStack((ItemLike)ModItems.CHAMPION_EGG_ITEM.get());
        ChampionEggItem.write(egg, ChampionsCommand.getEntityKey(entityType), tier, affixes);
        return egg;
    }

    private static EntityType<?> getTypeOrThrow(ResourceLocation resourceLocation) throws CommandSyntaxException {
        return (EntityType)((Holder.Reference)ForgeRegistries.ENTITY_TYPES.getDelegate(resourceLocation).orElseThrow(() -> UNKNOWN_ENTITY.create((Object)resourceLocation))).get();
    }

    private static ResourceLocation getEntityKey(EntityType<?> entityType) {
        return Optional.ofNullable(ForgeRegistries.ENTITY_TYPES.getKey(entityType)).orElse(ResourceLocation.withDefaultNamespace((String)"pig"));
    }
}

