/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ContentsFilteredItemHandler;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.settings.StorageSettingsHandler;

public abstract class MovingStorageWrapper
implements IStorageWrapper {
    private final Runnable stackChangeHandler;
    private final ItemStack storageStack;
    private final Runnable contentsChangeHandler;
    @Nullable
    private InventoryHandler inventoryHandler = null;
    @Nullable
    private ContentsFilteredItemHandler contentsFilteredItemHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    @Nullable
    private SettingsHandler settingsHandler;
    private final RenderInfo renderInfo;
    private final Function<UUID, IStorageSavedData> getStorageData;
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();
    private final Predicate<ItemStack> isUpgradeRunnable;

    private MovingStorageWrapper(ItemStack storageStack, Runnable onContentsChanged, Runnable onStackChanged, Function<UUID, IStorageSavedData> getStorageData, Predicate<ItemStack> isUpgradeRunnable) {
        this.storageStack = storageStack;
        this.contentsChangeHandler = onContentsChanged;
        this.stackChangeHandler = onStackChanged;
        this.renderInfo = new MovingStorageRenderInfo(storageStack);
        this.getStorageData = getStorageData;
        this.isUpgradeRunnable = isUpgradeRunnable;
        if (MovingStorageWrapper.isLimitedBarrel(storageStack)) {
            this.registerUpgradeDefaultsHandler(VoidUpgradeWrapper.class, LimitedBarrelBlockEntity.VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT);
        }
    }

    private static int getNumberOfDisplayItems(ItemStack stack) {
        return stack.m_41720_() instanceof BarrelBlockItem ? 4 : 1;
    }

    public static MovingStorageWrapper fromStack(ItemStack stack, Runnable onContentsChanged, Runnable onStackChanged, Function<UUID, IStorageSavedData> getStorageData, final BooleanSupplier isLocked, final Consumer<Boolean> setLocked, Predicate<ItemStack> isUpgradeRunnable) {
        MovingStorageWrapper movingStorageWrapper = new MovingStorageWrapper(stack, onContentsChanged, onStackChanged, getStorageData, isUpgradeRunnable){

            @Override
            public boolean isLocked() {
                return isLocked.getAsBoolean();
            }

            @Override
            public void setLocked(boolean locked) {
                setLocked.accept(locked);
            }
        };
        NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").ifPresent(movingStorageWrapper::setContentsUuid);
        return movingStorageWrapper;
    }

    public boolean isUpgradeRunnable(ItemStack upgrade) {
        return this.isUpgradeRunnable.test(upgrade);
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public abstract boolean isLocked();

    public abstract void setLocked(boolean var1);

    public void setContentsChangeHandler(Runnable contentsChangeHandler) {
    }

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        return this.getInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.inventoryHandler == null) {
            this.initInventoryHandler();
        }
        return this.inventoryHandler;
    }

    private void initInventoryHandler() {
        this.inventoryHandler = new InventoryHandler(this.getNumberOfInventorySlots(), this, this.getContentsNbt(), this.contentsChangeHandler, StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this), Config.SERVER.stackUpgrade){

            protected boolean isAllowed(ItemStack stack) {
                return MovingStorageWrapper.this.isAllowedInStorage(stack);
            }
        };
        this.inventoryHandler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        this.inventoryHandler.setShouldInsertIntoEmpty(this::emptyInventorySlotsAcceptItems);
        this.inventoryHandler.onInit();
    }

    private boolean emptyInventorySlotsAcceptItems() {
        return !StorageBlockItem.isLocked(this.storageStack) || this.allowsEmptySlotsMatchingItemInsertsWhenLocked();
    }

    private boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return !MovingStorageWrapper.isLimitedBarrel(this.storageStack);
    }

    public int getNumberOfInventorySlots() {
        return NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfInventorySlots").orElseGet(() -> {
            int defaultNumberOfInventorySlots = MovingStorageWrapper.getDefaultNumberOfInventorySlots(this.storageStack);
            NBTHelper.setInteger((ItemStack)this.storageStack, (String)"numberOfInventorySlots", (int)defaultNumberOfInventorySlots);
            this.stackChangeHandler.run();
            return defaultNumberOfInventorySlots;
        });
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (this.isLocked() && this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            if (this.contentsFilteredItemHandler == null) {
                this.contentsFilteredItemHandler = new ContentsFilteredItemHandler(this::getInventoryIOHandler, () -> this.getInventoryHandler().getSlotTracker(), () -> (MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
            }
            return this.contentsFilteredItemHandler;
        }
        return this.getInventoryIOHandler();
    }

    private ITrackedContentsItemHandler getInventoryIOHandler() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    public SettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new StorageSettingsHandler(this.getSettingsNbt(), this.contentsChangeHandler, this::getInventoryHandler, () -> this.renderInfo){

                @Override
                protected int getNumberOfDisplayItems() {
                    return MovingStorageWrapper.getNumberOfDisplayItems(MovingStorageWrapper.this.storageStack);
                }

                @Override
                protected void saveCategoryNbt(CompoundTag settingsNbt, String categoryName, CompoundTag tag) {
                    super.saveCategoryNbt(settingsNbt, categoryName, tag);
                    MovingStorageWrapper.this.contentsChangeHandler.run();
                    if (categoryName.equals("item_display")) {
                        MovingStorageWrapper.this.stackChangeHandler.run();
                    }
                }
            } : NoopStorageWrapper.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getContentsNbt(), this.contentsChangeHandler, () -> {
                if (this.inventoryHandler != null) {
                    this.inventoryHandler.clearListeners();
                    this.inventoryHandler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
                ((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return super.isItemValid(slot, stack) && (stack.m_41619_() || "sophisticatedstorage".equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135827_()) || stack.m_204117_(ModItems.STORAGE_UPGRADE_TAG));
                }
            };
            this.upgradeDefaultsHandlers.forEach(this::registerUpgradeDefaultsHandlerInUpgradeHandler);
        }
        return this.upgradeHandler;
    }

    private <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandlerInUpgradeHandler(Class<T> wrapperClass, Consumer<? extends IUpgradeWrapper> defaultsHandler) {
        this.upgradeHandler.registerUpgradeDefaultsHandler(wrapperClass, defaultsHandler);
    }

    public int getNumberOfUpgradeSlots() {
        return NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfUpgradeSlots").orElseGet(() -> {
            int defaultNumberOfUpgradeSlots = MovingStorageWrapper.getDefaultNumberOfUpgradeSlots(this.storageStack);
            NBTHelper.setInteger((ItemStack)this.storageStack, (String)"numberOfUpgradeSlots", (int)defaultNumberOfUpgradeSlots);
            this.stackChangeHandler.run();
            return defaultNumberOfUpgradeSlots;
        });
    }

    public Optional<UUID> getContentsUuid() {
        return NBTHelper.getUniqueId((ItemStack)this.storageStack, (String)"uuid");
    }

    public static boolean hasContentsUuid(ItemStack storageStack) {
        return NBTHelper.hasTag((ItemStack)storageStack, (String)"uuid");
    }

    private CompoundTag getSettingsNbt() {
        UUID storageId = this.getContentsUuid().orElseGet(this::getNewUuid);
        IStorageSavedData storageData = this.getStorageData.apply(storageId);
        CompoundTag baseContentsNbt = storageData.getContents();
        if (!baseContentsNbt.m_128441_("settings")) {
            baseContentsNbt.m_128365_("settings", (Tag)new CompoundTag());
            storageData.setContents(baseContentsNbt);
        }
        return baseContentsNbt.m_128469_("settings");
    }

    private CompoundTag getContentsNbt() {
        UUID storageId = this.getContentsUuid().orElseGet(this::getNewUuid);
        IStorageSavedData storageData = this.getStorageData.apply(storageId);
        CompoundTag baseContentsNbt = storageData.getContents();
        if (!baseContentsNbt.m_128441_("contents")) {
            baseContentsNbt.m_128365_("contents", (Tag)new CompoundTag());
            storageData.setContents(baseContentsNbt);
        }
        return baseContentsNbt.m_128469_("contents");
    }

    public int getMainColor() {
        return StorageBlockItem.getMainColorFromStack(this.storageStack).orElse(-1);
    }

    public int getAccentColor() {
        return StorageBlockItem.getAccentColorFromStack(this.storageStack).orElse(-1);
    }

    public Optional<Integer> getOpenTabId() {
        return NBTHelper.getInt((ItemStack)this.storageStack, (String)"openTabId");
    }

    public void setOpenTabId(int openTabId) {
        NBTHelper.setInteger((ItemStack)this.storageStack, (String)"openTabId", (int)openTabId);
        this.stackChangeHandler.run();
    }

    public void removeOpenTabId() {
        NBTHelper.removeTag((ItemStack)this.storageStack, (String)"openTabId");
        this.stackChangeHandler.run();
    }

    public void setColors(int mainColor, int accentColor) {
        Item item = this.storageStack.m_41720_();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            tintableBlockItem.setMainColor(this.storageStack, mainColor);
            tintableBlockItem.setAccentColor(this.storageStack, accentColor);
            this.stackChangeHandler.run();
        }
    }

    public void setSortBy(SortBy sortBy) {
        NBTHelper.setEnumConstant((ItemStack)this.storageStack, (String)"sortBy", (Enum)sortBy);
        this.stackChangeHandler.run();
    }

    public SortBy getSortBy() {
        return NBTHelper.getEnumConstant((ItemStack)this.storageStack, (String)"sortBy", SortBy::fromName).orElse(SortBy.NAME);
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        slotIndexesExcludedFromSort.addAll(this.getInventoryHandler().getNoSortSlots());
        InventorySorter.sortHandler((IItemHandlerModifiable)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new IncompatibleClassChangeError();
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    public void onContentsNbtUpdated() {
        this.inventoryHandler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.refreshInventoryForInputOutput();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
    }

    public void setPersistent(boolean persistent) {
    }

    public void fillWithLoot(Player playerEntity) {
    }

    public RenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
    }

    public int getColumnsTaken() {
        return 0;
    }

    public void setContentsUuid(UUID contentsUuid) {
        NBTHelper.setUniqueId((ItemStack)this.storageStack, (String)"uuid", (UUID)contentsUuid);
        this.onContentsNbtUpdated();
    }

    public static int getDefaultNumberOfInventorySlots(ItemStack storageStack) {
        int n;
        BlockItemBase blockItem;
        Item item = storageStack.m_41720_();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).m_40614_()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    public static int getDefaultNumberOfUpgradeSlots(ItemStack storageStack) {
        int n;
        BlockItemBase blockItem;
        Item item = storageStack.m_41720_();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).m_40614_()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }

    private boolean isAllowedInStorage(ItemStack stack) {
        if (!(this.storageStack.m_41720_() instanceof ShulkerBoxItem)) {
            return true;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        return !(block instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) && !(block instanceof ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.m_41720_());
    }

    public String getStorageType() {
        Item storageItem = this.storageStack.m_41720_();
        if (!(storageItem instanceof BlockItem)) {
            return "undefined";
        }
        BlockItem blockItem = (BlockItem)storageItem;
        if (blockItem.m_40614_() instanceof ChestBlock) {
            return "chest";
        }
        if (blockItem.m_40614_() instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) {
            return "shulker_box";
        }
        if (blockItem.m_40614_() instanceof LimitedBarrelBlock) {
            return "limited_barrel";
        }
        if (blockItem.m_40614_() instanceof BarrelBlock) {
            return "barrel";
        }
        return "undefined";
    }

    public Component getDisplayName() {
        return this.storageStack.m_41611_();
    }

    public void changeSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        this.setNumberOfInventorySlots(this.getNumberOfInventorySlots() + additionalInventorySlots);
        this.getInventoryHandler().changeSlots(additionalInventorySlots);
        this.setNumberOfUpgradeSlots(this.getNumberOfUpgradeSlots() + additionalUpgradeSlots);
        this.getUpgradeHandler().increaseSize(additionalUpgradeSlots);
    }

    public void setNumberOfInventorySlots(int numberOfInventorySlots) {
        NBTHelper.setInteger((ItemStack)this.storageStack, (String)"numberOfInventorySlots", (int)numberOfInventorySlots);
        this.stackChangeHandler.run();
    }

    public void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        NBTHelper.setInteger((ItemStack)this.storageStack, (String)"numberOfUpgradeSlots", (int)numberOfUpgradeSlots);
        this.stackChangeHandler.run();
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }

    public ItemStack getWrappedStorageStack() {
        return this.storageStack;
    }

    public int getBaseStackSizeMultiplier() {
        int n;
        BlockItem blockItem;
        Item item = this.storageStack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getBaseStackSizeMultiplier();
        } else {
            n = 1;
        }
        return n;
    }

    public static boolean isLimitedBarrel(ItemStack storageItem) {
        BlockItem blockItem;
        Item item = storageItem.m_41720_();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof LimitedBarrelBlock;
    }

    private class MovingStorageRenderInfo
    extends RenderInfo {
        public MovingStorageRenderInfo(ItemStack storageStack) {
            super(() -> net$p3pp3rf1y$sophisticatedstorage$entity$MovingStorageWrapper$this.stackChangeHandler, MovingStorageWrapper.isLimitedBarrel(storageStack));
            this.deserialize();
        }

        protected void serializeRenderInfo(CompoundTag renderInfo) {
            NBTHelper.setCompoundNBT((ItemStack)MovingStorageWrapper.this.storageStack, (String)"renderInfo", (CompoundTag)renderInfo.m_6426_());
        }

        protected Optional<CompoundTag> getRenderInfoTag() {
            return NBTHelper.getCompound((ItemStack)MovingStorageWrapper.this.storageStack, (String)"renderInfo");
        }
    }
}

