/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.item;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import umpaz.brewinandchewin.common.registry.BnCEffects;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BoozeItem
extends Item {
    private final Fluid fluid;
    public static final Set<Supplier<MobEffect>> RED_EFFECTS = Set.of(BnCEffects.TIPSY, () -> MobEffects.f_19594_);

    public BoozeItem(Fluid fluid, Item.Properties properties) {
        super(properties);
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41614_()) {
            if (player.m_36391_(heldStack.getFoodProperties((LivingEntity)player).m_38747_())) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)heldStack);
            }
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.f_46443_) {
            Optional<Pair> tipsy = stack.getFoodProperties(consumer).m_38749_().stream().filter(pair -> ((MobEffectInstance)pair.getFirst()).m_19544_() == BnCEffects.TIPSY.get()).findFirst();
            this.affectConsumer(consumer, tipsy.map(pair -> ((MobEffectInstance)pair.getFirst()).m_19557_()).orElse(0), tipsy.map(pair -> ((MobEffectInstance)pair.getFirst()).m_19564_()).orElse(-1));
        }
        ItemStack containerStack = stack.getCraftingRemainingItem();
        if (stack.m_41614_()) {
            super.m_5922_(stack, level, consumer);
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        if (stack.m_41619_()) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!((Player)consumer).m_150110_().f_35937_ && !player.m_150109_().m_36054_(containerStack)) {
                player.m_36176_(containerStack, false);
            }
        }
        return stack;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11911_;
    }

    public void affectConsumer(LivingEntity consumer, int duration, int potency) {
        if (consumer.m_21023_((MobEffect)BnCEffects.TIPSY.get())) {
            MobEffectInstance effect = consumer.m_21124_((MobEffect)BnCEffects.TIPSY.get());
            consumer.m_7292_(new MobEffectInstance((MobEffect)BnCEffects.TIPSY.get(), effect.m_19557_() == -1 ? -1 : effect.m_19557_() + duration, Math.min(effect.m_19564_() + potency + 1, 9), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip, (float)1.0f);
        for (int i = 0; i < tooltip.size(); ++i) {
            Component component = tooltip.get(i);
            if (!RED_EFFECTS.stream().anyMatch(supplier -> component.m_240452_((Component)Component.m_237115_((String)((MobEffect)supplier.get()).m_19481_())))) continue;
            tooltip.set(i, (Component)component.m_6881_().m_130940_(ChatFormatting.RED));
        }
    }
}

