/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import umpaz.brewinandchewin.client.gui.KegRecipeBookComponent;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.client.utility.BnCRectangle;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;

public class KegScreen
extends AbstractContainerScreen<KegMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("brewinandchewin", "textures/gui/keg.png");
    private static final BnCRectangle PROGRESS_ARROW = new BnCRectangle(80, 25, 0, 18);
    public static final BnCRectangle COLD_BAR = new BnCRectangle(35, 55, 8, 4);
    public static final BnCRectangle CHILLY_BAR = new BnCRectangle(43, 55, 9, 4);
    public static final BnCRectangle WARM_BAR = new BnCRectangle(60, 55, 9, 4);
    public static final BnCRectangle HOT_BAR = new BnCRectangle(69, 55, 8, 4);
    private static final BnCRectangle LEFT_BUBBLE = new BnCRectangle(109, 44, 9, 24);
    private static final BnCRectangle RIGHT_BUBBLE = new BnCRectangle(147, 44, 9, 24);
    private final KegRecipeBookComponent recipeBookComponent;
    private boolean widthTooNarrow;
    private static final Map<Fluid, Component> FLUID_CONTAINER_COMPONENTS = new HashMap<Fluid, Component>();

    public KegScreen(KegMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.recipeBookComponent = new KegRecipeBookComponent(Minecraft.m_91087_().f_91073_.m_7465_());
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97728_ = 28;
    }

    public void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.f_97728_ = 38;
        this.recipeBookComponent.m_100309_(this.f_96543_, this.f_96544_, this.f_96541_, this.widthTooNarrow, (RecipeBookMenu)this.f_97732_);
        this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
        if (((Boolean)BnCConfiguration.ENABLE_RECIPE_BOOK_KEG.get()).booleanValue()) {
            this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 5, this.f_96544_ / 2 - 49, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, button -> {
                this.recipeBookComponent.m_100384_();
                this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
                button.m_264152_(this.f_97735_ + 5, this.f_96544_ / 2 - 49);
            }));
        } else {
            this.recipeBookComponent.hide();
            this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
        }
        this.m_7787_((GuiEventListener)this.recipeBookComponent);
        this.m_264313_((GuiEventListener)this.recipeBookComponent);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.recipeBookComponent.m_100386_();
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        if (this.recipeBookComponent.m_100385_() && this.widthTooNarrow) {
            this.m_7286_(gui, partialTicks, mouseX, mouseY);
            this.recipeBookComponent.m_88315_(gui, mouseX, mouseY, partialTicks);
        } else {
            this.recipeBookComponent.m_88315_(gui, mouseX, mouseY, partialTicks);
            super.m_88315_(gui, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.m_280128_(gui, this.f_97735_, this.f_97736_, false, partialTicks);
        }
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 119, this.f_97736_ + 15, 176, 22, 27, 33);
        this.renderTankTooltip(gui, mouseX, mouseY);
        this.renderTemperatureTooltip(gui, mouseX, mouseY);
        this.m_280072_(gui, mouseX, mouseY);
        this.recipeBookComponent.m_280545_(gui, this.f_97735_, this.f_97736_, mouseX, mouseY);
    }

    public static void clearFluidContainerComponents() {
        FLUID_CONTAINER_COMPONENTS.clear();
    }

    private void renderTankTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        KegFermentingRecipe fermentingRecipe;
        Recipe<?> recipe;
        if (this.m_6774_(120, 19, 24, 28, mouseX, mouseY) && !((KegMenu)this.f_97732_).kegTank.isEmpty() && (!((recipe = this.recipeBookComponent.getGhostRecipe()) instanceof KegFermentingRecipe) || (fermentingRecipe = (KegFermentingRecipe)recipe).getFluidIngredient() == null || fermentingRecipe.getFluidIngredient().getFluid().m_6212_(((KegMenu)this.f_97732_).kegTank.getFluid().getRawFluid()))) {
            MutableComponent containerComponent = BnCTextUtils.getTranslation("container.keg.served_in", FLUID_CONTAINER_COMPONENTS.computeIfAbsent(((KegMenu)this.f_97732_).kegTank.getFluid().getFluid(), fluid -> {
                MutableComponent component = MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_).m_130940_(ChatFormatting.GRAY);
                int amountAdded = 0;
                for (KegPouringRecipe recipe2 : Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(pouringRecipe -> pouringRecipe.getRawFluid().m_6212_(fluid)).sorted(Comparator.comparing(recipe -> recipe.getContainer().m_41720_().m_41466_().getString())).toList()) {
                    if (amountAdded > 0) {
                        component.m_130946_(", ");
                    }
                    component.m_7220_((Component)recipe2.getContainer().m_41720_().m_41466_().m_6879_().m_130940_(ChatFormatting.GRAY));
                    ++amountAdded;
                }
                return component;
            })).m_130940_(ChatFormatting.GRAY);
            MutableComponent component = MutableComponent.m_237204_((ComponentContents)((KegMenu)this.f_97732_).kegTank.getFluid().getDisplayName().m_214077_()).m_130946_(" (%s/%s mB)".formatted(((KegMenu)this.f_97732_).kegTank.getFluidAmount(), ((KegMenu)this.f_97732_).kegTank.getCapacity()));
            gui.m_280666_(this.f_96547_, List.of(component, containerComponent), mouseX, mouseY);
        }
    }

    private void renderTemperatureTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        block8: {
            block9: {
                if (!this.m_6774_(35, 54, 42, 5, mouseX, mouseY)) break block8;
                Recipe<?> recipe = this.recipeBookComponent.getGhostRecipe();
                if (!(recipe instanceof KegFermentingRecipe)) break block9;
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                if (!KegBlockEntity.isValidTemp(((KegMenu)this.f_97732_).getKegTemperature(), fermentingRecipe.getTemperature())) break block8;
            }
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            MutableComponent key = switch (((KegMenu)this.f_97732_).getKegTemperature()) {
                case 1 -> BnCTextUtils.getTranslation("container.keg.cold", new Object[0]);
                case 2 -> BnCTextUtils.getTranslation("container.keg.chilly", new Object[0]);
                case 4 -> BnCTextUtils.getTranslation("container.keg.warm", new Object[0]);
                case 5 -> BnCTextUtils.getTranslation("container.keg.hot", new Object[0]);
                default -> BnCTextUtils.getTranslation("container.keg.normal", new Object[0]);
            };
            tooltip.add(key);
            gui.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics gui, int mouseX, int mouseY) {
        super.m_280003_(gui, mouseX, mouseY);
        gui.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        KegFermentingRecipe fermentingRecipe;
        Recipe<?> recipe;
        FluidStack fluidStack;
        int temp;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.f_96541_ == null) {
            return;
        }
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int l = ((KegMenu)this.f_97732_).getFermentProgressionScaled();
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + PROGRESS_ARROW.x(), this.f_97736_ + PROGRESS_ARROW.y(), 176, 4, l + 1, PROGRESS_ARROW.height());
        if (((KegMenu)this.f_97732_).isFermenting()) {
            int bubScale = (int)(((KegMenu)this.f_97732_).getProgression() / 80.0f * (float)LEFT_BUBBLE.height()) % (LEFT_BUBBLE.height() + 1);
            gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + LEFT_BUBBLE.x(), this.f_97736_ + LEFT_BUBBLE.y() - bubScale, 176, 79 - bubScale, LEFT_BUBBLE.width(), bubScale + 1);
            gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + RIGHT_BUBBLE.x(), this.f_97736_ + RIGHT_BUBBLE.y() - bubScale, 186, 79 - bubScale, RIGHT_BUBBLE.width(), bubScale + 1);
        }
        if ((temp = ((KegMenu)this.f_97732_).getKegTemperature()) == 1) {
            gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + COLD_BAR.x(), this.f_97736_ + COLD_BAR.y(), 176, 0, COLD_BAR.width(), COLD_BAR.height());
        }
        if (temp < 3) {
            gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + CHILLY_BAR.x(), this.f_97736_ + CHILLY_BAR.y(), 184, 0, CHILLY_BAR.width(), CHILLY_BAR.height());
        }
        if (temp > 3) {
            gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + WARM_BAR.x(), this.f_97736_ + WARM_BAR.y(), 201, 0, WARM_BAR.width(), WARM_BAR.height());
        }
        if (temp == 5) {
            gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + HOT_BAR.x(), this.f_97736_ + HOT_BAR.y(), 210, 0, HOT_BAR.width(), HOT_BAR.height());
        }
        if (!(fluidStack = ((KegMenu)this.f_97732_).kegTank.getFluid()).isEmpty() && (!((recipe = this.recipeBookComponent.getGhostRecipe()) instanceof KegFermentingRecipe) || (fermentingRecipe = (KegFermentingRecipe)recipe).getFluidIngredient() == null && ((KegMenu)this.f_97732_).kegTank.isEmpty() || fermentingRecipe.getFluidIngredient() != null && fermentingRecipe.getFluidIngredient().getFluid().m_6212_(fluidStack.getRawFluid()))) {
            IClientFluidTypeExtensions fluidTypeExtensions;
            ResourceLocation stillTexture;
            if (((Boolean)BnCConfiguration.RENDER_FLUID_IN_KEG.get()).booleanValue() && (stillTexture = (fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid())).getStillTexture(fluidStack)) != null) {
                int y2;
                int y1;
                TextureAtlasSprite sprite = (TextureAtlasSprite)this.f_96541_.m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
                int tintColor = fluidTypeExtensions.getTintColor(fluidStack);
                float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f;
                float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(tintColor & 0xFF) / 255.0f;
                float capacity = (float)Math.min(((KegMenu)this.f_97732_).kegTank.getCapacity(), ((KegMenu)this.f_97732_).kegTank.getFluidAmount()) / (float)((KegMenu)this.f_97732_).kegTank.getCapacity();
                if ((double)capacity > 0.57) {
                    y1 = this.f_97736_ + 19 + (int)(12.0f * (1.0f - (capacity - 0.57f) / 0.43f));
                    y2 = this.f_97736_ + 19 + 12;
                    float topCapacity = (capacity - 0.57f) / 0.43f;
                    float vDistance = sprite.m_118412_() - sprite.m_118411_();
                    float v0 = sprite.m_118411_() + 0.25f * vDistance + 0.75f * vDistance * (1.0f - topCapacity);
                    gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 120, this.f_97735_ + 120 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
                    gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 120 + 16, this.f_97735_ + 120 + 16 + 8, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
                }
                y1 = this.f_97736_ + 31 + (int)(16.0f * (1.0f - Math.min(1.0f, capacity / 0.57f)));
                y2 = this.f_97736_ + 31 + 16;
                float vDistance = sprite.m_118412_() - sprite.m_118411_();
                float v0 = sprite.m_118411_() + vDistance * (1.0f - Math.min(1.0f, capacity / 0.57f));
                gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 120, this.f_97735_ + 120 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
                gui.m_280479_(sprite.m_247685_(), this.f_97735_ + 120 + 16, this.f_97735_ + 120 + 16 + 8, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
            }
            ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay(Minecraft.m_91087_().f_91073_.m_9598_(), fluidStack).m_41777_();
            Optional<KegPouringRecipe> pouringRecipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> ItemStack.m_150942_((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.m_8043_(this.f_96541_.f_91073_.m_9598_()))).findFirst();
            int pourCount = pouringRecipe.map(kegPouringRecipe -> Math.min(((KegMenu)this.f_97732_).kegTank.getCapacity(), ((KegMenu)this.f_97732_).kegTank.getFluidAmount()) / kegPouringRecipe.getAmount()).orElse(1);
            itemDisplay.m_41764_(pourCount);
            if (!itemDisplay.m_41619_()) {
                gui.m_280480_(itemDisplay, this.f_97735_ + 124, this.f_97736_ + 23);
                gui.m_280370_(this.f_96541_.f_91062_, itemDisplay, this.f_97735_ + 124, this.f_97736_ + 23);
            }
        }
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.m_100385_()) && super.m_6774_(x, y, width, height, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
        if (this.recipeBookComponent.m_6375_(mouseX, mouseY, buttonId)) {
            this.m_7522_((GuiEventListener)this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.m_100385_() || super.m_6375_(mouseX, mouseY, buttonId);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int x, int y, int buttonIdx) {
        boolean flag = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + this.f_97726_) || mouseY >= (double)(y + this.f_97727_);
        return flag && this.recipeBookComponent.m_100297_(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, buttonIdx);
    }

    protected void m_6597_(Slot slot, int mouseX, int mouseY, ClickType clickType) {
        super.m_6597_(slot, mouseX, mouseY, clickType);
        this.recipeBookComponent.m_6904_(slot);
    }

    public void m_6916_() {
        this.recipeBookComponent.m_100387_();
    }

    public RecipeBookComponent m_5564_() {
        return this.recipeBookComponent;
    }
}

