/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.type.list.MarkList;

public class GuiStackX
extends GuiFlow {
    @Override
    public int minWidth(List<? extends GuiChildControl> controls, int spacing, int availableWidth) {
        boolean has = false;
        int width = -spacing;
        for (GuiChildControl guiChildControl : controls) {
            int min = guiChildControl.getMinWidth(availableWidth);
            if (min != -1) {
                width += min;
                has = true;
            }
            width += spacing;
        }
        return has ? width : -1;
    }

    @Override
    public int preferredWidth(List<? extends GuiChildControl> controls, int spacing, int availableWidth) {
        int width = -spacing;
        for (GuiChildControl guiChildControl : controls) {
            width += guiChildControl.getPreferredWidth(availableWidth) + spacing;
        }
        return width;
    }

    @Override
    public int minHeight(List<? extends GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = -1;
        for (GuiChildControl guiChildControl : controls) {
            height = Math.max(height, guiChildControl.getMinHeight(availableHeight));
        }
        return height;
    }

    @Override
    public int preferredHeight(List<? extends GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = 0;
        for (GuiChildControl guiChildControl : controls) {
            height = Math.max(height, guiChildControl.getPreferredHeight(availableHeight));
        }
        return height;
    }

    @Override
    public void flowX(List<? extends GuiChildControl> controls, int spacing, Align align, int width, int preferred, boolean endless) {
        block30: {
            int available;
            block31: {
                block29: {
                    available = width - spacing * (controls.size() - 1);
                    MarkList<? extends GuiChildControl> list = new MarkList<GuiChildControl>(controls);
                    if (width >= preferred) {
                        if (align == Align.STRETCH && !GuiStackX.areChildrenExpandableX(controls)) {
                            for (GuiChildControl guiChildControl : list) {
                                int n = guiChildControl.getMinWidth(width);
                                if (n != -1) {
                                    available -= n;
                                    guiChildControl.setWidth(n, width);
                                    continue;
                                }
                                guiChildControl.setWidth(0, width);
                            }
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                    int toAdd = Maths.min(average, available, guiChildControl.getPreferredWidth(width) - guiChildControl.getWidth());
                                    if (toAdd <= 0) {
                                        iterator.mark();
                                        continue;
                                    }
                                    available -= guiChildControl.addWidth(toAdd, width);
                                    if (!guiChildControl.isMaxWidth(width)) continue;
                                    iterator.mark();
                                }
                            }
                            list.clear();
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                    available -= guiChildControl.addWidth(Math.min(average, available), width);
                                    if (!guiChildControl.isMaxWidth(width)) continue;
                                    iterator.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)itr.next();
                                guiChildControl.setWidth(guiChildControl.getPreferredWidth(width), width);
                                if (!guiChildControl.isExpandableX()) {
                                    itr.mark();
                                }
                                available -= guiChildControl.getWidth();
                            }
                            if (align == Align.STRETCH || GuiStackX.areChildrenExpandableX(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                        available -= guiChildControl.addWidth(Math.min(average, available), width);
                                        if (!guiChildControl.isMaxWidth(width)) continue;
                                        iterator.mark();
                                    }
                                }
                            }
                        }
                    } else if (endless) {
                        for (GuiChildControl guiChildControl : controls) {
                            guiChildControl.setWidth(guiChildControl.getPreferredWidth(width), width);
                        }
                        align = Align.LEFT;
                    } else {
                        for (GuiChildControl guiChildControl : list) {
                            int n = guiChildControl.getMinWidth(width);
                            if (n != -1) {
                                available -= n;
                                guiChildControl.setWidth(n, width);
                                continue;
                            }
                            guiChildControl.setWidth(0, width);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                int prefer = guiChildControl.getPreferredWidth(width);
                                available -= guiChildControl.addWidth(Math.min(average, Math.min(prefer - guiChildControl.getWidth(), available)), width);
                                if (!guiChildControl.isMaxWidth(width) && prefer > guiChildControl.getWidth()) continue;
                                iterator.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                available -= guiChildControl.addWidth(Math.min(average, available), width);
                                if (!guiChildControl.isMaxWidth(width)) continue;
                                iterator.mark();
                            }
                        }
                    }
                    for (GuiChildControl guiChildControl : controls) {
                        guiChildControl.flowX();
                    }
                    if (available > 0 && align != Align.LEFT) break block29;
                    int x = 0;
                    for (GuiChildControl guiChildControl : controls) {
                        guiChildControl.setX(x);
                        x += guiChildControl.getWidth() + spacing;
                    }
                    break block30;
                }
                if (align != Align.RIGHT) break block31;
                int x = width;
                for (GuiChildControl guiChildControl : controls) {
                    guiChildControl.setX(x -= guiChildControl.getWidth());
                    x -= spacing;
                }
                break block30;
            }
            if (align != Align.CENTER && align != Align.STRETCH) break block30;
            int x = available / 2;
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setX(x);
                x += guiChildControl.getWidth() + spacing;
            }
        }
    }

    @Override
    public void flowY(List<? extends GuiChildControl> controls, int spacing, VAlign valign, int width, int height, int preferred, boolean endless) {
        int maxHeight = height;
        if (endless && preferred > height) {
            maxHeight = preferred;
        }
        boolean expandable = GuiStackX.areChildrenExpandableY(controls);
        if (valign == VAlign.TOP && !expandable) {
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setY(0);
                guiChildControl.setHeight(Math.min(maxHeight, guiChildControl.getPreferredHeight(height)), height);
                guiChildControl.flowY();
            }
        } else if (valign == VAlign.STRETCH || expandable) {
            for (GuiChildControl guiChildControl : controls) {
                if (guiChildControl.isExpandableY() || valign == VAlign.STRETCH) {
                    guiChildControl.setHeight(maxHeight, height);
                } else {
                    guiChildControl.setHeight(Math.min(maxHeight, guiChildControl.getPreferredHeight(height)), height);
                }
                guiChildControl.setY(0);
                guiChildControl.flowY();
            }
        } else if (valign == VAlign.BOTTOM) {
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setHeight(Math.min(maxHeight, guiChildControl.getPreferredHeight(height)), height);
                guiChildControl.setY(maxHeight - guiChildControl.getHeight());
                guiChildControl.flowY();
            }
        } else {
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setHeight(Math.min(maxHeight, guiChildControl.getPreferredHeight(height)), height);
                guiChildControl.setY((int)Math.ceil((double)maxHeight / 2.0 - (double)guiChildControl.getHeight() / 2.0));
                guiChildControl.flowY();
            }
        }
    }
}

