/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumableBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.api.temperature.DynamicModifierBase;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ITemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureImmunityEnum;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureCapability;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.TemperatureModifierRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttributeBuilder;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class TemperatureUtilInternal
implements ITemperatureUtil {
    public static final String COAT_TAG = "Coat";
    public static final AttributeBuilder HEATING_TEMPERATURE = new AttributeBuilder((Attribute)AttributeRegistry.HEATING_TEMPERATURE.get(), "attribute.legendarysurvivaloverhaul.heating_temperature");
    public static final AttributeBuilder COOLING_TEMPERATURE = new AttributeBuilder((Attribute)AttributeRegistry.COOLING_TEMPERATURE.get(), "attribute.legendarysurvivaloverhaul.cooling_temperature");
    public static final AttributeBuilder HEAT_RESISTANCE = new AttributeBuilder((Attribute)AttributeRegistry.HEAT_RESISTANCE.get(), "attribute.legendarysurvivaloverhaul.heat_resistance");
    public static final AttributeBuilder COLD_RESISTANCE = new AttributeBuilder((Attribute)AttributeRegistry.COLD_RESISTANCE.get(), "attribute.legendarysurvivaloverhaul.cold_resistance");
    public static final AttributeBuilder THERMAL_RESISTANCE = new AttributeBuilder((Attribute)AttributeRegistry.THERMAL_RESISTANCE.get(), "attribute.legendarysurvivaloverhaul.thermal_resistance");
    public static final Map<EquipmentSlot, UUID> equipmentSlotTemperatureUuid = new HashMap<EquipmentSlot, UUID>();

    @Override
    public float getPlayerTargetTemperature(Player player) {
        float sum = 0.0f;
        Level world = player.m_20193_();
        BlockPos pos = WorldUtil.getSidedBlockPos(world, (Entity)player);
        for (ModifierBase modifier : TemperatureModifierRegistry.MODIFIERS_REGISTRY.get().getValues()) {
            float worldInfluence = modifier.getWorldInfluence(player, world, pos);
            float playerInfluence = modifier.getPlayerInfluence(player);
            if (player.m_21205_().m_150930_(Items.f_42751_)) {
                LegendarySurvivalOverhaul.LOGGER.info("{} : world influence={}, player influence={}", (Object)TemperatureModifierRegistry.MODIFIERS_REGISTRY.get().getKey((Object)modifier), (Object)Float.valueOf(worldInfluence), (Object)Float.valueOf(playerInfluence));
            }
            sum += worldInfluence + playerInfluence;
        }
        float dynamicModification = 0.0f;
        for (DynamicModifierBase dynamicModifier : TemperatureModifierRegistry.DYNAMIC_MODIFIERS_REGISTRY.get().getValues()) {
            float worldInfluence = dynamicModifier.applyDynamicWorldInfluence(player, world, pos, sum, dynamicModification);
            float playerInfluence = dynamicModifier.applyDynamicPlayerInfluence(player, sum, dynamicModification);
            if (player.m_21205_().m_150930_(Items.f_42751_)) {
                LegendarySurvivalOverhaul.LOGGER.info("{} : dynamic world influence={}, dynamic player influence={}", (Object)TemperatureModifierRegistry.DYNAMIC_MODIFIERS_REGISTRY.get().getKey((Object)dynamicModifier), (Object)Float.valueOf(worldInfluence), (Object)Float.valueOf(playerInfluence));
            }
            dynamicModification += worldInfluence + playerInfluence;
        }
        return MathUtil.round(sum += dynamicModification, 1);
    }

    @Override
    public float getWorldTemperature(Level world, BlockPos pos) {
        float sum = 0.0f;
        for (ModifierBase modifier : TemperatureModifierRegistry.MODIFIERS_REGISTRY.get().getValues()) {
            sum += modifier.getWorldInfluence(null, world, pos);
        }
        float dynamicModification = 0.0f;
        for (DynamicModifierBase dynamicModifier : TemperatureModifierRegistry.DYNAMIC_MODIFIERS_REGISTRY.get().getValues()) {
            dynamicModification += dynamicModifier.applyDynamicWorldInfluence(null, world, pos, sum, dynamicModification);
        }
        return MathUtil.round(sum += dynamicModification, 1);
    }

    @Override
    public float clampTemperature(float temperature) {
        return Mth.m_14036_((float)temperature, (float)TemperatureEnum.FROSTBITE.getLowerBound(), (float)TemperatureEnum.HEAT_STROKE.getUpperBound());
    }

    @Override
    public TemperatureEnum getTemperatureEnum(float temperature) {
        return TemperatureEnum.get(temperature);
    }

    @Override
    public boolean hasImmunity(Player player, TemperatureImmunityEnum immunity) {
        if (!Config.Baked.temperatureEnabled) {
            return false;
        }
        TemperatureCapability cap = CapabilityUtil.getTempCapability(player);
        return cap.getTemperatureImmunities().contains(immunity.id);
    }

    @Override
    public void addImmunity(Player player, TemperatureImmunityEnum immunity) {
        if (!Config.Baked.temperatureEnabled) {
            return;
        }
        TemperatureCapability cap = CapabilityUtil.getTempCapability(player);
        cap.addTemperatureImmunityId(immunity.id);
    }

    @Override
    public void removeImmunity(Player player, TemperatureImmunityEnum immunity) {
        if (!Config.Baked.temperatureEnabled) {
            return;
        }
        TemperatureCapability cap = CapabilityUtil.getTempCapability(player);
        cap.removeTemperatureImmunityId(immunity.id);
    }

    @Override
    public void applyConsumableTemperature(Player player, ResourceLocation itemRegistryName) {
        List<JsonTemperatureConsumable> jsonConsumableTemperatures;
        if (Config.Baked.temperatureEnabled && (jsonConsumableTemperatures = TemperatureDataManager.getConsumable(itemRegistryName)) != null) {
            for (JsonTemperatureConsumable jtc : jsonConsumableTemperatures) {
                if (jtc.getEffect() == null) continue;
                player.m_7292_(new MobEffectInstance(jtc.getEffect(), jtc.duration, Math.abs(jtc.temperatureLevel) - 1, false, false, true));
                player.m_21195_(jtc.getOppositeEffect());
            }
        }
    }

    @Override
    public void applyConsumableBlockTemperature(Player player, BlockState blockState) {
        ResourceLocation blockRegistryName;
        List<JsonTemperatureConsumableBlock> jsonConsumableBlockTemperatures;
        if (Config.Baked.temperatureEnabled && (jsonConsumableBlockTemperatures = TemperatureDataManager.getConsumableBlock(blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()))) != null) {
            for (JsonTemperatureConsumableBlock jtcb : jsonConsumableBlockTemperatures) {
                if (jtcb.getEffect() == null || !jtcb.matchesState(blockState)) continue;
                player.m_7292_(new MobEffectInstance(jtcb.getEffect(), jtcb.duration, Math.abs(jtcb.temperatureLevel) - 1, false, false, true));
                player.m_21195_(jtcb.getOppositeEffect());
            }
        }
    }

    @Override
    public void addTemperatureModifier(Player player, double temperature, UUID uuid) {
        HEATING_TEMPERATURE.addModifier(player, uuid, Math.max(temperature, 0.0));
        COOLING_TEMPERATURE.addModifier(player, uuid, Math.min(temperature, 0.0));
    }

    @Override
    public void addHeatResistanceModifier(Player player, double resistance, UUID uuid) {
        HEAT_RESISTANCE.addModifier(player, uuid, resistance);
    }

    @Override
    public void addColdResistanceModifier(Player player, double resistance, UUID uuid) {
        COLD_RESISTANCE.addModifier(player, uuid, resistance);
    }

    @Override
    public void addThermalResistanceModifier(Player player, double resistance, UUID uuid) {
        THERMAL_RESISTANCE.addModifier(player, uuid, resistance);
    }

    @Override
    public void setArmorCoatTag(ItemStack stack, String coatId) {
        CompoundTag compound;
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if ((compound = stack.m_41783_()) != null) {
            compound.m_128359_(COAT_TAG, coatId);
        }
    }

    @Override
    public String getArmorCoatTag(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41783_();
            if (compound != null && compound.m_128441_("ArmorPadding")) {
                compound.m_128359_(COAT_TAG, compound.m_128461_("ArmorPadding"));
                compound.m_128473_("ArmorPadding");
            }
            if (compound != null && compound.m_128441_(COAT_TAG)) {
                return compound.m_128461_(COAT_TAG);
            }
        }
        return "";
    }

    @Override
    public void removeArmorCoatTag(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41782_() && (compound = stack.m_41783_()) != null && compound.m_128441_(COAT_TAG)) {
            compound.m_128473_(COAT_TAG);
        }
    }

    static {
        equipmentSlotTemperatureUuid.put(EquipmentSlot.HEAD, UUID.fromString("06e30f27-2340-4bdb-9a91-a657f1e2880f"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.CHEST, UUID.fromString("1e7ef99e-2fe7-4edc-95b1-27fa056eae6d"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.LEGS, UUID.fromString("f46c0aff-7381-4f99-890e-75eb3781af21"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.FEET, UUID.fromString("34f98220-a7d9-4cc1-8930-b3dc4115ad07"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.MAINHAND, UUID.fromString("7b1e1c2c-746c-4631-8037-f76c82529909"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.OFFHAND, UUID.fromString("389caa2f-2c18-49da-b521-b53cc5713e14"));
    }
}

