/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class PlayerModelUtil {
    private static final Map<Pose, Map<BoundingBoxBodyPartEnum, AABB>> POSE_BOXES = new HashMap<Pose, Map<BoundingBoxBodyPartEnum, AABB>>();
    private static final Map<BoundingBoxBodyPartEnum, AABB> DEFAULT_BOXES = Collections.emptyMap();

    public static List<BodyPartEnum> getPreciseEntityImpact(Entity hitEntity, Player player) {
        Vec3 impactPosition = PlayerModelUtil.getIntersectionPointFromPlayer(hitEntity, player);
        if (impactPosition == null) {
            return Collections.emptyList();
        }
        if (player.m_20089_() == Pose.STANDING || player.m_20089_() == Pose.CROUCHING) {
            Map<BoundingBoxBodyPartEnum, AABB> posePlayerBBParts = POSE_BOXES.getOrDefault(player.m_20089_(), DEFAULT_BOXES);
            for (Map.Entry<BoundingBoxBodyPartEnum, AABB> posePlayerBBPart : posePlayerBBParts.entrySet()) {
                AABB bodyPartAABB = MathUtil.inflateMultiplier(player.m_20191_(), posePlayerBBPart.getValue());
                AABB newPlayerBB = posePlayerBBPart.getKey() == BoundingBoxBodyPartEnum.HEAD ? MathUtil.horizontalUpInflate(bodyPartAABB, 1.5) : (posePlayerBBPart.getKey() == BoundingBoxBodyPartEnum.FEET ? MathUtil.horizontalDownInflate(bodyPartAABB, 1.5) : MathUtil.horizontalInflate(bodyPartAABB, 1.5));
                if (!newPlayerBB.m_82390_(impactPosition)) continue;
                double hitSideDistanceRatio = PlayerModelUtil.getRightRatioDistance(impactPosition, player);
                return Collections.singletonList(posePlayerBBPart.getKey().getBodyPartFromSideDistance(hitSideDistanceRatio));
            }
        } else if (player.m_20089_() == Pose.SWIMMING) {
            return Collections.singletonList(PlayerModelUtil.getSwimmingPlayerBodyPart(impactPosition, player));
        }
        return Collections.emptyList();
    }

    public static List<BodyPartEnum> getEntityImpact(Entity hitEntity, Player player) {
        AABB intersection = null;
        if (hitEntity instanceof LivingEntity) {
            intersection = PlayerModelUtil.getMeleeAttackIntersectionAABBFromEntity(hitEntity, player);
        }
        if (intersection == null) {
            intersection = PlayerModelUtil.getIntersectionAABBFromEntity(hitEntity, player);
        }
        if (intersection == null) {
            return Collections.emptyList();
        }
        if (player.m_20089_() == Pose.STANDING || player.m_20089_() == Pose.CROUCHING) {
            return PlayerModelUtil.getPlayerBodyParts(intersection, player);
        }
        if (player.m_20089_() == Pose.SWIMMING) {
            return Collections.singletonList(PlayerModelUtil.getSwimmingPlayerBodyPart(intersection.m_82399_(), player));
        }
        return Collections.emptyList();
    }

    public static BodyPartEnum getSwimmingPlayerBodyPart(Vec3 hitPosition, Player player) {
        double ratioForwardDistance = PlayerModelUtil.getForwardRatioDistance(hitPosition, player);
        BoundingBoxBodyPartEnum boxBodyPartEnum = BoundingBoxBodyPartEnum.getFromFeetToHeadDistance(ratioForwardDistance);
        double hitSideDistanceRatio = PlayerModelUtil.getRightRatioDistance(hitPosition, player);
        return boxBodyPartEnum.getBodyPartFromSideDistance(hitSideDistanceRatio);
    }

    public static List<BodyPartEnum> getPlayerBodyParts(AABB intersection, Player player) {
        Map<BoundingBoxBodyPartEnum, AABB> posePlayerBBParts = POSE_BOXES.getOrDefault(player.m_20089_(), POSE_BOXES.get(Pose.STANDING));
        ArrayList<BodyPartEnum> impactedParts = new ArrayList<BodyPartEnum>();
        double hitSideDistanceRatio = PlayerModelUtil.getRightRatioDistance(intersection.m_82399_(), player);
        for (Map.Entry<BoundingBoxBodyPartEnum, AABB> posePlayerBBPart : posePlayerBBParts.entrySet()) {
            AABB newPlayerBB = MathUtil.inflateMultiplier(player.m_20191_(), posePlayerBBPart.getValue());
            if (!newPlayerBB.m_82381_(intersection)) continue;
            impactedParts.add(posePlayerBBPart.getKey().getBodyPartFromSideDistance(hitSideDistanceRatio));
        }
        return impactedParts;
    }

    public static AABB getIntersectionAABBFromEntity(Entity hitEntity, Player player) {
        float[] inflateValues;
        AABB intersection = null;
        for (float inflateValue : inflateValues = new float[]{1.0f, 1.5f, 2.0f, 2.5f}) {
            AABB inflatedEntityHitBB = hitEntity.m_20191_().m_82400_((double)inflateValue);
            if (!inflatedEntityHitBB.m_82381_(player.m_20191_())) continue;
            intersection = inflatedEntityHitBB.m_82323_(player.m_20191_());
            break;
        }
        return intersection;
    }

    public static AABB getMeleeAttackIntersectionAABBFromEntity(Entity hitEntity, Player player) {
        float[] inflateValues;
        AABB entityHitBB = MathUtil.inflateMultiplier(hitEntity.m_20191_(), new AABB(0.0, 0.3, 0.0, 1.0, 0.8, 1.0));
        AABB intersection = null;
        for (float inflateValue : inflateValues = new float[]{1.0f, 1.5f, 2.0f, 2.5f}) {
            AABB inflatedEntityHitBB = MathUtil.horizontalInflate(entityHitBB, inflateValue);
            if (!inflatedEntityHitBB.m_82381_(player.m_20191_())) continue;
            intersection = inflatedEntityHitBB.m_82323_(player.m_20191_());
            break;
        }
        return intersection;
    }

    public static Vec3 getIntersectionPointFromPlayer(Entity hitEntity, Player player) {
        float[] inflateValues;
        for (float inflateValue : inflateValues = new float[]{0.5f, 1.0f, 1.5f}) {
            AABB inflatedPlayerBB = player.m_20191_().m_82400_((double)inflateValue);
            if (!inflatedPlayerBB.m_82381_(hitEntity.m_20191_())) continue;
            return inflatedPlayerBB.m_82323_(hitEntity.m_20191_()).m_82399_();
        }
        return null;
    }

    public static double getYHitSignedAngle(Vec3 hitPosition, Player player) {
        Vec3 hitVector = player.m_20182_().m_82505_(hitPosition).m_82541_();
        Vec3 playerVector = Vec3.m_82498_((float)0.0f, (float)player.f_20883_).m_82541_();
        hitVector = new Vec3(hitVector.f_82479_, 0.0, hitVector.f_82481_).m_82541_();
        playerVector = new Vec3(playerVector.f_82479_, 0.0, playerVector.f_82481_).m_82541_();
        return Math.atan2(playerVector.m_82537_(hitVector).m_82526_(new Vec3(0.0, 1.0, 0.0)), playerVector.m_82526_(hitVector)) / 6.28318530718 * 360.0 % 180.0;
    }

    public static double getRightRatioDistance(Vec3 hitPosition, Player player) {
        Vec3 hitVector = hitPosition.m_82546_(player.m_20182_()).m_82541_();
        Vec3 rotatedPlayerRotVector = Vec3.m_82498_((float)0.0f, (float)player.f_20883_).m_82524_(1.5707964f).m_82541_();
        return hitVector.m_82526_(rotatedPlayerRotVector) / (double)player.m_20205_();
    }

    public static double getForwardRatioDistance(Vec3 hitPosition, Player player) {
        Vec3 hitVector = hitPosition.m_82546_(player.m_20182_()).m_82541_();
        Vec3 playerRotVector = Vec3.m_82498_((float)0.0f, (float)player.f_20883_).m_82541_();
        return hitVector.m_82526_(playerRotVector) / (double)player.m_20205_();
    }

    public static double getBodyRotHitSignedAngle(Vec3 hitPosition, Player player) {
        Vec3 hitVector = player.m_20182_().m_82505_(hitPosition).m_82541_();
        Vec3 playerVector = Vec3.m_82498_((float)0.0f, (float)player.f_20883_).m_82541_();
        double k = -playerVector.f_82479_ * hitVector.f_82479_ - playerVector.f_82480_ * hitVector.f_82480_ - playerVector.f_82481_ * hitVector.f_82481_;
        Vec3 projectedHitVector = new Vec3(hitVector.f_82479_ + k * playerVector.f_82479_, hitVector.f_82480_ + k * playerVector.f_82480_, hitVector.f_82481_ + k * playerVector.f_82481_);
        Vec3 verticalAxis = new Vec3(0.0, 1.0, 0.0);
        return Math.atan2(projectedHitVector.m_82537_(verticalAxis).m_82526_(playerVector), projectedHitVector.m_82526_(verticalAxis)) / 6.28318530718 * 360.0 % 180.0;
    }

    static {
        HashMap<BoundingBoxBodyPartEnum, AABB> newBB = new HashMap<BoundingBoxBodyPartEnum, AABB>();
        newBB.put(BoundingBoxBodyPartEnum.FEET, new AABB(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        newBB.put(BoundingBoxBodyPartEnum.LEGS, new AABB(0.0, 0.15, 0.0, 1.0, 0.45, 1.0));
        newBB.put(BoundingBoxBodyPartEnum.CHEST, new AABB(0.0, 0.45, 0.0, 1.0, 0.8, 1.0));
        newBB.put(BoundingBoxBodyPartEnum.HEAD, new AABB(0.0, 0.8, 0.0, 1.0, 1.0, 1.0));
        POSE_BOXES.put(Pose.STANDING, Collections.unmodifiableMap(newBB));
        newBB = new LinkedHashMap();
        newBB.put(BoundingBoxBodyPartEnum.FEET, new AABB(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        newBB.put(BoundingBoxBodyPartEnum.LEGS, new AABB(0.0, 0.15, 0.0, 1.0, 0.4, 1.0));
        newBB.put(BoundingBoxBodyPartEnum.CHEST, new AABB(0.0, 0.4, 0.0, 1.0, 0.75, 1.0));
        newBB.put(BoundingBoxBodyPartEnum.HEAD, new AABB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0));
        POSE_BOXES.put(Pose.CROUCHING, Collections.unmodifiableMap(newBB));
        POSE_BOXES.put(Pose.SWIMMING, DEFAULT_BOXES);
    }

    public static enum BoundingBoxBodyPartEnum {
        HEAD(BodyPartEnum.HEAD, BodyPartEnum.HEAD, BodyPartEnum.HEAD),
        CHEST(BodyPartEnum.LEFT_ARM, BodyPartEnum.CHEST, BodyPartEnum.RIGHT_ARM),
        LEGS(BodyPartEnum.LEFT_LEG, null, BodyPartEnum.RIGHT_LEG),
        FEET(BodyPartEnum.LEFT_FOOT, null, BodyPartEnum.RIGHT_FOOT);

        public final BodyPartEnum leftBodyPart;
        public final BodyPartEnum middleBodyPart;
        public final BodyPartEnum rightBodyPart;

        private BoundingBoxBodyPartEnum(BodyPartEnum leftBodyPart, BodyPartEnum middleBodyPart, BodyPartEnum rightBodyPart) {
            this.leftBodyPart = leftBodyPart;
            this.middleBodyPart = middleBodyPart;
            this.rightBodyPart = rightBodyPart;
        }

        public BodyPartEnum getBodyPartsEnumFromAngle(double angle) {
            switch (this) {
                case HEAD: {
                    return this.middleBodyPart;
                }
                case CHEST: {
                    if (angle >= 40.0 && angle < 140.0) {
                        return this.leftBodyPart;
                    }
                    if (angle < -40.0 && angle >= -140.0) {
                        return this.rightBodyPart;
                    }
                    return this.middleBodyPart;
                }
            }
            if (angle >= 0.0) {
                return this.leftBodyPart;
            }
            return this.rightBodyPart;
        }

        public BodyPartEnum getBodyPartFromSideDistance(double ratioDistance) {
            switch (this) {
                case HEAD: {
                    return this.middleBodyPart;
                }
                case CHEST: {
                    if (ratioDistance < 0.7 && ratioDistance > -0.7) {
                        return this.middleBodyPart;
                    }
                    if (ratioDistance < 0.0) {
                        return this.rightBodyPart;
                    }
                    return this.leftBodyPart;
                }
            }
            if (ratioDistance < 0.0) {
                return this.rightBodyPart;
            }
            return this.leftBodyPart;
        }

        public static BoundingBoxBodyPartEnum getFromFeetToHeadDistance(double ratioDistance) {
            if (ratioDistance >= 0.2) {
                return HEAD;
            }
            if (ratioDistance >= -0.05) {
                return CHEST;
            }
            if (ratioDistance >= -0.35) {
                return LEGS;
            }
            return FEET;
        }
    }
}

