/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util;

import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.EnumUtil;

public class ItemUtil {
    private ItemUtil() {
    }

    public static boolean canBeEquippedInSlot(ItemStack stack, EquipmentSlot slot) {
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40402_() == slot;
        }
        if (stack.m_41720_() instanceof ShieldItem) {
            return slot == EquipmentSlot.OFFHAND;
        }
        if (CuriosUtil.isCuriosItem(stack)) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND;
    }

    public static EquipmentSlot getEquippableSlot(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40402_();
        }
        if (stack.m_41720_() instanceof ShieldItem) {
            return EquipmentSlot.OFFHAND;
        }
        return EquipmentSlot.MAINHAND;
    }

    public static String compassLocation(Entity entity) {
        return switch (Config.Baked.compassInfoMode) {
            default -> throw new IncompatibleClassChangeError();
            case EnumUtil.CompassInfo.FULL -> "XYZ: " + entity.m_20183_().m_123341_() + " / " + entity.m_20183_().m_123342_() + " / " + entity.m_20183_().m_123343_();
            case EnumUtil.CompassInfo.HORIZONTAL -> "XZ: " + entity.m_20183_().m_123341_() + " / " + entity.m_20183_().m_123343_();
            case EnumUtil.CompassInfo.NONE -> "";
        };
    }

    public static String compassDeathLocation(Player player) {
        Optional globalDeathPos = player.m_219759_();
        if (globalDeathPos.isPresent()) {
            GlobalPos pos = (GlobalPos)globalDeathPos.get();
            return Component.m_237110_((String)"message.legendarysurvivaloverhaul.compass_death_location", (Object[])new Object[]{pos.m_122640_().m_135782_().m_135815_().replace("_", " ").replace("-", " "), pos.m_122646_().m_123341_(), pos.m_122646_().m_123342_(), pos.m_122646_().m_123343_()}).getString();
        }
        return "";
    }
}

