/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstBlockListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncThirstBlocksPacket {
    private final Map<ResourceLocation, List<JsonThirstBlock>> thirstBlocks;
    private final int size;

    public SyncThirstBlocksPacket(Map<ResourceLocation, List<JsonThirstBlock>> thirstBlocks) {
        this.thirstBlocks = Map.copyOf(thirstBlocks);
        this.size = thirstBlocks.size();
    }

    public static void encode(SyncThirstBlocksPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, List<JsonThirstBlock>> e : message.thirstBlocks.entrySet()) {
            buffer.m_130085_(e.getKey());
            buffer.writeInt(e.getValue().size());
            DataResult r = JsonThirstBlock.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, e.getValue());
            r.result().ifPresent(j -> ((ListTag)j).forEach(k -> buffer.m_130079_((CompoundTag)k)));
        }
    }

    public static SyncThirstBlocksPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, List<JsonThirstBlock>> thirstBlocks = new HashMap<ResourceLocation, List<JsonThirstBlock>>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            int jtbSize = buffer.readInt();
            ArrayList jtbList = new ArrayList();
            for (int j = 0; j < jtbSize; ++j) {
                CompoundTag tag = buffer.m_130260_();
                if (tag == null) continue;
                DataResult r = JsonThirstBlock.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
                r.result().ifPresent(jtbList::add);
            }
            thirstBlocks.put(key, jtbList);
        }
        return new SyncThirstBlocksPacket(thirstBlocks);
    }

    public static void handle(SyncThirstBlocksPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncThirstBlocksPacket.syncThirstBlocks(message.thirstBlocks)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncThirstBlocks(final Map<ResourceLocation, List<JsonThirstBlock>> thirstBlocks) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                ThirstBlockListener.acceptServerThirstBlocks(thirstBlocks);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, List<JsonThirstBlock>> thirstBlocks) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncThirstBlocksPacket(thirstBlocks));
    }
}

