/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureMountListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureMountsPacket {
    private final Map<ResourceLocation, JsonTemperatureResistance> temperatureMounts;
    private final int size;

    public SyncTemperatureMountsPacket(Map<ResourceLocation, JsonTemperatureResistance> temperatureMounts) {
        this.temperatureMounts = Map.copyOf(temperatureMounts);
        this.size = temperatureMounts.size();
    }

    public static void encode(SyncTemperatureMountsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonTemperatureResistance> e : message.temperatureMounts.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonTemperatureResistance.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncTemperatureMountsPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonTemperatureResistance> temperatureMounts = new HashMap<ResourceLocation, JsonTemperatureResistance>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonTemperatureResistance.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> temperatureMounts.put(key, (JsonTemperatureResistance)t));
        }
        return new SyncTemperatureMountsPacket(temperatureMounts);
    }

    public static void handle(SyncTemperatureMountsPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureMountsPacket.syncTemperatureMounts(message.temperatureMounts)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureMounts(final Map<ResourceLocation, JsonTemperatureResistance> temperatureMounts) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureMountListener.acceptServerTemperatureMounts(temperatureMounts);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonTemperatureResistance> temperatureMounts) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureMountsPacket(temperatureMounts));
    }
}

