/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonBodyPartResistance;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartResistanceItemListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncBodyPartResistanceItemsPacket {
    private final Map<ResourceLocation, JsonBodyPartResistance> bodyPartResistanceItems;
    private final int size;

    public SyncBodyPartResistanceItemsPacket(Map<ResourceLocation, JsonBodyPartResistance> bodyPartResistanceItems) {
        this.bodyPartResistanceItems = Map.copyOf(bodyPartResistanceItems);
        this.size = bodyPartResistanceItems.size();
    }

    public static void encode(SyncBodyPartResistanceItemsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonBodyPartResistance> e : message.bodyPartResistanceItems.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonBodyPartResistance.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncBodyPartResistanceItemsPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonBodyPartResistance> bodyPartResistanceItems = new HashMap<ResourceLocation, JsonBodyPartResistance>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonBodyPartResistance.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> bodyPartResistanceItems.put(key, (JsonBodyPartResistance)t));
        }
        return new SyncBodyPartResistanceItemsPacket(bodyPartResistanceItems);
    }

    public static void handle(SyncBodyPartResistanceItemsPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncBodyPartResistanceItemsPacket.syncBodyPartResistanceItems(message.bodyPartResistanceItems)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncBodyPartResistanceItems(final Map<ResourceLocation, JsonBodyPartResistance> bodyPartResistanceItems) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                BodyPartResistanceItemListener.acceptServerBodyPartResistanceItems(bodyPartResistanceItems);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonBodyPartResistance> bodyPartResistanceItems) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncBodyPartResistanceItemsPacket(bodyPartResistanceItems));
    }
}

