/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.temperature.TemperatureItemCapability;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.KeyMappingRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class ThermometerItem
extends Item {
    public ThermometerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.m_5776_()) {
            TemperatureItemCapability tempCap = CapabilityUtil.getTempItemCapability(player.m_21205_());
            float temperature = tempCap.getWorldTemperatureLevel();
            MutableComponent temperatureComponent = Config.Baked.renderTemperatureInFahrenheit ? Component.m_237113_((String)(WorldUtil.toFahrenheit(temperature) + "\u00b0F")) : Component.m_237113_((String)(temperature + "\u00b0C"));
            player.m_5661_((Component)temperatureComponent, true);
        }
        return super.m_7203_(level, player, hand);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new TemperatureItemCapability.TemperatureItemProvider();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)KeyMappingRegistry.showAddedDesc.getKey().m_84873_())) {
            text.add(Component.m_237115_((String)"tooltip.legendarysurvivaloverhaul.thermometer.description"));
            if (LegendarySurvivalOverhaul.curiosLoaded) {
                text.add(Component.m_237115_((String)"tooltip.legendarysurvivaloverhaul.thermometer.bauble_description"));
            }
        } else {
            text.add(Component.m_237113_((String)(ChatFormatting.GRAY + I18n.m_118938_((String)"tooltip.legendarysurvivaloverhaul.added_desc.activate", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, I18n.m_118938_((String)KeyMappingRegistry.showAddedDesc.m_90863_().getString(), (Object[])new Object[0]), ChatFormatting.GRAY}))));
        }
        tooltipComponents.addAll(text);
    }
}

