/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.commands.CommandBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class HealthCommand
extends CommandBase {
    public HealthCommand() {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"healthoverhaul").requires(p_198521_0_ -> p_198521_0_.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82127_((String)"shield").executes(src -> new HealthCommand().getShield((CommandSourceStack)src.getSource(), EntityArgument.m_91461_((CommandContext)src, (String)"target"))))).then(Commands.m_82127_((String)"additionalHealth").executes(src -> new HealthCommand().getHealth((CommandSourceStack)src.getSource(), EntityArgument.m_91461_((CommandContext)src, (String)"target"))))).then(Commands.m_82127_((String)"brokenHearts").executes(src -> new HealthCommand().getBrokenHeart((CommandSourceStack)src.getSource(), EntityArgument.m_91461_((CommandContext)src, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"shield").then(Commands.m_82129_((String)"shieldValue", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Config.Baked.maxShieldHealth)).executes(src -> new HealthCommand().setShield((CommandSourceStack)src.getSource(), EntityArgument.m_91461_((CommandContext)src, (String)"target"), DoubleArgumentType.getDouble((CommandContext)src, (String)"shieldValue")))))).then(Commands.m_82127_((String)"additionalHealth").then(Commands.m_82129_((String)"healthValue", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Config.Baked.maxAdditionalHealth)).executes(src -> new HealthCommand().setHealth((CommandSourceStack)src.getSource(), EntityArgument.m_91461_((CommandContext)src, (String)"target"), DoubleArgumentType.getDouble((CommandContext)src, (String)"healthValue")))))))));
    }

    private int getShield(CommandSourceStack src, Collection<? extends Entity> entities) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(src.m_81373_() instanceof Player)) continue;
                reply.append("Player ").append(player.m_7755_().getString()).append(" ");
                float shieldValue = CapabilityUtil.getHealthCapability(player).getShieldHealth();
                reply.append("Shield: ").append(shieldValue).append("\n");
                src.m_288197_(() -> Component.m_237113_((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int getHealth(CommandSourceStack src, Collection<? extends Entity> entities) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(src.m_81373_() instanceof Player)) continue;
                reply.append("Player ").append(player.m_7755_().getString()).append(" ");
                float healthValue = CapabilityUtil.getHealthCapability(player).getAdditionalHealth();
                reply.append("Additional Health: ").append(healthValue).append("\n");
                src.m_288197_(() -> Component.m_237113_((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int getBrokenHeart(CommandSourceStack src, Collection<? extends Entity> entities) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(src.m_81373_() instanceof Player)) continue;
                reply.append("Player ").append(player.m_7755_().getString()).append(" ");
                float brokenHearts = (int)player.m_21133_((Attribute)AttributeRegistry.BROKEN_HEART.get());
                reply.append("Broken Hearts: ").append(brokenHearts).append("\n");
                src.m_288197_(() -> Component.m_237113_((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int setShield(CommandSourceStack src, Collection<? extends Entity> entities, double shieldValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            CapabilityUtil.getHealthCapability(player).setShieldHealth((float)shieldValue);
        }
        return 1;
    }

    private int setHealth(CommandSourceStack src, Collection<? extends Entity> entities, double healthValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            CapabilityUtil.getHealthCapability(player).setAdditionalHealth((float)healthValue);
        }
        return 1;
    }
}

