/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.capabilities.bodydamage;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;

public class BodyPart {
    private float oldMaxHealth;
    private float oldDamage;
    private final float healthMultiplier;
    private final BodyPartEnum bodyPartEnum;
    private float damage;
    private float maxHealth;
    private int remainingHealingTicks;
    private float healingPerTicks;

    public BodyPart(BodyPartEnum bodyPart, float healthMultiplier) {
        this.bodyPartEnum = bodyPart;
        this.healthMultiplier = healthMultiplier;
        this.oldMaxHealth = 0.0f;
        this.oldDamage = 0.0f;
    }

    public boolean isDirty() {
        return this.oldDamage != this.damage || this.oldMaxHealth != this.maxHealth;
    }

    public void setClean() {
        this.oldDamage = this.damage;
        this.oldMaxHealth = this.maxHealth;
    }

    public void heal(float value) {
        this.setDamage(this.damage - value);
    }

    public void hurt(float value) {
        this.setDamage(this.damage + value);
    }

    public boolean isMaxHealth() {
        return this.damage == 0.0f;
    }

    public float getHealthMultiplier() {
        return this.healthMultiplier;
    }

    public BodyPartEnum getBodyPartEnum() {
        return this.bodyPartEnum;
    }

    public void setDamage(float value) {
        this.damage = Mth.m_14036_((float)value, (float)0.0f, (float)this.maxHealth);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setMaxHealth(float value) {
        this.maxHealth = value;
        this.damage = Math.min(this.maxHealth, this.damage);
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public int getRemainingHealingTicks() {
        return this.remainingHealingTicks;
    }

    public void reduceRemainingHealingTicks(int healingTick) {
        this.remainingHealingTicks -= Math.min(healingTick, this.remainingHealingTicks);
        if (this.remainingHealingTicks == 0) {
            this.healingPerTicks = 0.0f;
        }
    }

    public float getHealingPerTicks() {
        return this.healingPerTicks;
    }

    public void setHealing(int healingTick, float healingValuePerTick) {
        this.remainingHealingTicks = healingTick;
        this.healingPerTicks = healingValuePerTick;
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        nbt.m_128350_(this.bodyPartEnum.name() + "_damage", this.damage);
        nbt.m_128350_(this.bodyPartEnum.name() + "_maxHealth", this.maxHealth);
        nbt.m_128350_(this.bodyPartEnum.name() + "_healingPerTicks", this.healingPerTicks);
        nbt.m_128405_(this.bodyPartEnum.name() + "_remainingHealingTicks", this.remainingHealingTicks);
        return nbt;
    }

    public void readNBT(CompoundTag compound) {
        this.setMaxHealth(compound.m_128457_(this.bodyPartEnum.name() + "_maxHealth"));
        this.setDamage(compound.m_128457_(this.bodyPartEnum.name() + "_damage"));
        this.remainingHealingTicks = compound.m_128451_(this.bodyPartEnum.name() + "_remainingHealingTicks");
        this.healingPerTicks = compound.m_128457_(this.bodyPartEnum.name() + "_healingPerTicks");
    }
}

