/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.health.HealthCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.overflowingbars.OverflowingBarsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class RenderHealthGui {
    private static HealthCapability HEALTH_CAP = null;
    private static final Random rand = new Random();
    public static final ResourceLocation ICONS = new ResourceLocation("legendarysurvivaloverhaul", "textures/gui/overlay.png");
    protected static final ResourceLocation MINECRAFT_GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final int HEART_TEXTURE_POS_Y = 146;
    private static final int HEART_TEXTURE_POS_X = 0;
    private static final int HEART_TEXTURE_WIDTH = 9;
    private static final int HEART_TEXTURE_HEIGHT = 9;
    public static final IGuiOverlay HEALTH_GUI = (forgeGui, guiGraphics, partialTicks, width, height) -> {
        LocalPlayer player;
        if (Config.Baked.healthOverhaulEnabled && !Minecraft.m_91087_().f_91066_.f_92062_ && forgeGui.shouldDrawSurvivalElements() && (player = forgeGui.getMinecraft().f_91074_) != null) {
            rand.setSeed((long)player.f_19797_ * 445L);
            forgeGui.setupOverlayRenderState(true, false);
            Minecraft.m_91087_().m_91307_().m_6180_("health");
            RenderHealthGui.drawHealthBar(forgeGui, guiGraphics, (Player)player, width, height);
            Minecraft.m_91087_().m_91307_().m_7238_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }
    };

    public static void drawHealthBar(ForgeGui forgeGui, GuiGraphics gui, Player player, int width, int height) {
        float shieldHealth;
        int brokenHearts;
        if (HEALTH_CAP == null || player.f_19797_ % 20 == 0) {
            HEALTH_CAP = CapabilityUtil.getHealthCapability(player);
        }
        if ((float)(brokenHearts = HealthUtil.getEffectiveBrokenHearts(player)) + (shieldHealth = HEALTH_CAP.getShieldHealth()) == 0.0f) {
            return;
        }
        int left = width / 2 - 91;
        int top = height - forgeGui.leftHeight;
        int playerHearts = 0;
        int totalHearts = Mth.m_14167_((float)(shieldHealth / 2.0f)) + brokenHearts;
        if (Config.Baked.appendBrokenShieldHeartsToHealthBar) {
            playerHearts = Mth.m_14167_((float)(player.m_21233_() / 2.0f));
            if (OverflowingBarsUtil.isHealthBarOverflowing()) {
                playerHearts = Math.min(10, playerHearts);
            }
            if ((playerHearts %= 10) > 0) {
                totalHearts += playerHearts;
                top += 10;
                forgeGui.leftHeight -= 10;
            }
        }
        int healthRows = Mth.m_14167_((float)((float)totalHearts / 10.0f));
        forgeGui.leftHeight += healthRows * 10;
        RenderHealthGui.renderHearts(gui, left, top, 10, playerHearts, brokenHearts, Mth.m_14167_((float)player.m_21223_()), shieldHealth);
    }

    public static void renderHearts(GuiGraphics gui, int left, int top, int rowHeight, int playerHearts, int brokenHearts, int health, float shieldHealth) {
        int shieldHearts = Mth.m_14165_((double)((double)shieldHealth / 2.0));
        for (int i1 = playerHearts + shieldHearts + brokenHearts - 1; i1 >= playerHearts; --i1) {
            boolean flag;
            int j1 = i1 / 10;
            int k1 = i1 % 10;
            int x = left + k1 * 8;
            int y = top - j1 * rowHeight;
            if ((float)health + shieldHealth <= 4.0f) {
                y += rand.nextInt(2);
            }
            boolean bl = flag = i1 >= brokenHearts + playerHearts;
            if (flag) {
                RenderHealthGui.renderHeart(gui, HeartType.CONTAINER, x, y, 0, false);
                RenderHealthGui.renderHeart(gui, HeartType.SHIELD, x, y, 0, shieldHealth < (float)(shieldHearts * 2) && i1 == shieldHearts - 1);
                continue;
            }
            RenderHealthGui.renderHeart(gui, HeartType.BROKEN, x, y, 0, false);
        }
    }

    public static void renderHeart(GuiGraphics gui, HeartType heartType, int x, int y, int yTexture, boolean halfIcon) {
        gui.m_280218_(heartType.location, x, y, heartType.getX(halfIcon), yTexture, 9, 9);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum HeartType {
        CONTAINER(MINECRAFT_GUI_ICONS_LOCATION, 0),
        SHIELD(MINECRAFT_GUI_ICONS_LOCATION, 8),
        BROKEN(ICONS, 0);

        private final ResourceLocation location;
        private final int index;

        private HeartType(ResourceLocation location, int index) {
            this.location = location;
            this.index = index;
        }

        public int getX(boolean halfIcon) {
            if (this == BROKEN) {
                return (16 + this.index) * 9;
            }
            int i = 0;
            if (this == SHIELD) {
                i = halfIcon ? 1 : 0;
            }
            return 16 + (this.index * 2 + i) * 9;
        }
    }
}

