/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.temperature;

import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;

public enum TemperatureEnum {
    FROSTBITE(0, 10),
    COLD(10, 16),
    NORMAL(16, 24),
    HOT(24, 30),
    HEAT_STROKE(30, 40);

    private final int lowerBound;
    private final int upperBound;

    private TemperatureEnum(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public boolean matches(float temperature) {
        return (temperature = TemperatureUtil.clampTemperature(temperature)) >= (float)this.lowerBound && temperature < (float)this.upperBound;
    }

    public static TemperatureEnum get(float temperature) {
        if (temperature < (float)TemperatureEnum.FROSTBITE.upperBound) {
            return FROSTBITE;
        }
        if (temperature >= (float)TemperatureEnum.COLD.lowerBound && temperature < (float)TemperatureEnum.COLD.upperBound) {
            return COLD;
        }
        if (temperature >= (float)TemperatureEnum.NORMAL.lowerBound && temperature < (float)TemperatureEnum.NORMAL.upperBound) {
            return NORMAL;
        }
        if (temperature >= (float)TemperatureEnum.HOT.lowerBound && temperature < (float)TemperatureEnum.HOT.upperBound) {
            return HOT;
        }
        return HEAT_STROKE;
    }

    public float getMiddle() {
        return (float)(this.upperBound + this.lowerBound) / 2.0f;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }
}

