/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.network.packet.client;

import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.network.PacketDirection;
import io.github.mortuusars.horseman.network.handler.ClientPacketsHandler;
import io.github.mortuusars.horseman.network.packet.IPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record SyncHorseDataS2CP(int entityId, List<ItemStack> inventory, ItemStack leadStack, boolean isHitched) implements IPacket
{
    public static final ResourceLocation ID = Horseman.resource("sync_horse_data");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.m_130130_(this.inventory.size());
        for (ItemStack itemStack : this.inventory) {
            buffer.m_130055_(itemStack);
        }
        buffer.m_130055_(this.leadStack);
        buffer.writeBoolean(this.isHitched);
        return buffer;
    }

    public static SyncHorseDataS2CP fromBuffer(FriendlyByteBuf buffer) {
        int entityId = buffer.m_130242_();
        int inventorySize = buffer.m_130242_();
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        for (int i = 0; i < inventorySize; ++i) {
            inventory.add(buffer.m_130267_());
        }
        return new SyncHorseDataS2CP(entityId, inventory, buffer.m_130267_(), buffer.readBoolean());
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        ClientPacketsHandler.syncHorseData(this);
        return true;
    }
}

