/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.less_wander;

import io.github.mortuusars.horseman.world.LessWanderingHorse;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements LessWanderingHorse {
    @Unique
    @Nullable
    private Vec3 horseman$wanderAnchor = null;

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public Vec3 horseman$getWanderAnchor() {
        return this.horseman$wanderAnchor;
    }

    @Override
    public void horseman$setWanderAnchor(@Nullable Vec3 pos) {
        this.horseman$wanderAnchor = pos;
    }

    @Inject(method={"equipSaddle"}, at={@At(value="RETURN")})
    protected void equipSaddle(SoundSource source, CallbackInfo ci) {
        if (LessWanderingHorse.isEnabled()) {
            this.horseman$wanderAnchor = this.m_20182_();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    protected void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (this.horseman$wanderAnchor != null && LessWanderingHorse.isEnabled()) {
            tag.m_128347_("HorsemanWanderAnchorX", this.horseman$wanderAnchor.f_82479_);
            tag.m_128347_("HorsemanWanderAnchorY", this.horseman$wanderAnchor.f_82480_);
            tag.m_128347_("HorsemanWanderAnchorZ", this.horseman$wanderAnchor.f_82481_);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    protected void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (!LessWanderingHorse.isEnabled()) {
            return;
        }
        @Nullable Double x = null;
        Double y = null;
        Double z = null;
        if (tag.m_128425_("HorsemanWanderAnchorX", 6)) {
            x = tag.m_128459_("HorsemanWanderAnchorX");
        }
        if (tag.m_128425_("HorsemanWanderAnchorY", 6)) {
            y = tag.m_128459_("HorsemanWanderAnchorY");
        }
        if (tag.m_128425_("HorsemanWanderAnchorZ", 6)) {
            z = tag.m_128459_("HorsemanWanderAnchorZ");
        }
        if (x != null && y != null && z != null) {
            this.horseman$wanderAnchor = new Vec3(x.doubleValue(), y.doubleValue(), z.doubleValue());
        }
    }
}

